<?php
if (!defined('ABSPATH')) exit;

/**
 * Render customization section with Tailwind styling
 */
function psfa_render_customization() {
    require_once PSFA_PLUGIN_DIR . 'core/shared/theme-manager.php';
    require_once PSFA_PLUGIN_DIR . 'core/shared/customization-helpers.php';
    
    $is_premium = false;
    $upgrade_url = 'https://paapiplugin.com/pricing/#plans';
    
    
    $themes = psfa_get_all_themes();
    $selected_theme = psfa_get_selected_theme();
    
    // Get current settings
    $button_text = get_option('psfa_button_text', 'Buy on Amazon');
    $button_border_radius = get_option('psfa_button_border_radius', '');
    $button_font_size = get_option('psfa_button_font_size', '');
    $button_font_weight = get_option('psfa_button_font_weight', '');
    $card_layout = get_option('psfa_card_layout', 'default');
    $title_font = get_option('psfa_title_font', '');
    $description_font = get_option('psfa_description_font', '');
    $price_font = get_option('psfa_price_font', '');
    $theme_colors = get_option('psfa_theme_colors', array());
    
    // Preserve other settings - API credentials
    $auth_type = get_option('psfa_auth_type', 'awssig4');
    $access_key = get_option('psfa_access_key_id', '');
    $secret_key = get_option('psfa_secret_access_key', '');
    $associate_tag = get_option('psfa_associate_tag', '');
    $oauth_client_id = get_option('psfa_oauth_client_id', '');
    $oauth_client_secret = get_option('psfa_oauth_client_secret', '');
    $oauth_credential_version = get_option('psfa_oauth_credential_version', '');
    $oauth_auth_region = get_option('psfa_oauth_auth_region', 'us-east-1');
    $marketplace = get_option('psfa_marketplace', 'www.amazon.com');
    $display_mode = get_option('psfa_display_mode', 'grid');
    $hide_banner = get_option('psfa_hide_category_banner', false);
    $hide_search = in_array(get_option('psfa_hide_search', '0'), array('1', 1, true, 'true'), true);
    $hide_filters = in_array(get_option('psfa_hide_filters', '0'), array('1', 1, true, 'true'), true);
    $filter_visibility = get_option('psfa_filter_visibility', array(
        'brand' => true, 'price' => true, 'sort' => true, 'condition' => true,
        'merchant' => true, 'availability' => true, 'has_deal' => true, 'deals' => true,
    ));
    
    $google_fonts = array(
        '' => 'Default (Theme Font)', 'Roboto' => 'Roboto', 'Open Sans' => 'Open Sans',
        'Lato' => 'Lato', 'Montserrat' => 'Montserrat', 'Poppins' => 'Poppins',
        'Raleway' => 'Raleway', 'Source Sans Pro' => 'Source Sans Pro',
        'Oswald' => 'Oswald', 'Playfair Display' => 'Playfair Display', 'Merriweather' => 'Merriweather',
    );
    ?>
    <form action="options.php" method="post">
        <?php settings_fields('psfa_settings'); ?>
        
        <!-- Hidden fields to preserve other settings -->
        <input type="hidden" name="psfa_auth_type" value="<?php echo esc_attr($auth_type); ?>">
        <input type="hidden" name="psfa_access_key_id" value="<?php echo esc_attr($access_key); ?>">
        <input type="hidden" name="psfa_secret_access_key" value="<?php echo esc_attr($secret_key); ?>">
        <input type="hidden" name="psfa_associate_tag" value="<?php echo esc_attr($associate_tag); ?>">
        <input type="hidden" name="psfa_oauth_client_id" value="<?php echo esc_attr($oauth_client_id); ?>">
        <input type="hidden" name="psfa_oauth_client_secret" value="<?php echo esc_attr($oauth_client_secret); ?>">
        <input type="hidden" name="psfa_oauth_credential_version" value="<?php echo esc_attr($oauth_credential_version); ?>">
        <input type="hidden" name="psfa_oauth_auth_region" value="<?php echo esc_attr($oauth_auth_region); ?>">
        <input type="hidden" name="psfa_marketplace" value="<?php echo esc_attr($marketplace); ?>">
        <input type="hidden" name="psfa_selected_theme" value="<?php echo esc_attr($selected_theme); ?>">
        <input type="hidden" name="psfa_display_mode" value="<?php echo esc_attr($display_mode); ?>">
        <input type="hidden" name="psfa_hide_category_banner" value="<?php echo $hide_banner ? '1' : '0'; ?>">
        <input type="hidden" name="psfa_hide_search" value="<?php echo $hide_search ? '1' : '0'; ?>">
        <input type="hidden" name="psfa_hide_filters" value="<?php echo $hide_filters ? '1' : '0'; ?>">
        <?php foreach ($filter_visibility as $filter_key => $filter_val): ?>
        <input type="hidden" name="psfa_filter_visibility[<?php echo esc_attr($filter_key); ?>]" value="<?php echo $filter_val ? '1' : '0'; ?>">
        <?php endforeach; ?>
        <?php 
        // Preserve features settings
        $saved_features = get_option('psfa_features', array());
        foreach ($saved_features as $fkey => $fval): ?>
        <input type="hidden" name="psfa_features[<?php echo esc_attr($fkey); ?>]" value="<?php echo $fval ? '1' : '0'; ?>">
        <?php endforeach; ?>
        
        <!-- Customization Cards Grid -->
        <div class="tw-grid tw-grid-cols-1 lg:tw-grid-cols-2 tw-gap-4 tw-mb-6">
            
            <!-- Button Customization Card -->
            <div class="tw-bg-white tw-rounded-xl tw-border tw-border-gray-200 tw-shadow-sm tw-p-5">
                <div class="tw-flex tw-items-center tw-gap-2 tw-mb-4">
                    <h3 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0">Button Customization</h3>
                    <span class="tw-px-2 tw-py-0.5 tw-text-xs tw-font-medium tw-border tw-border-solid tw-border-gray-300 tw-bg-gray-100 tw-text-gray-600 tw-rounded">Premium</span>
                </div>
                <p class="tw-text-sm tw-text-gray-500 tw-m-0 tw-mb-4">Customize the "Buy on Amazon" button appearance.</p>
                
                <?php if ($is_premium) : ?>
                <div class="tw-space-y-4">
                    <div>
                        <label class="tw-block tw-text-sm tw-font-medium tw-text-gray-700 tw-mb-1.5">Button Text <?php echo wp_kses_post( psfa_info_tip('The text displayed on the "Buy on Amazon" button.') ); ?></label>
                        <input type="text" name="psfa_button_text" value="<?php echo esc_attr($button_text); ?>" 
                               class="tw-w-full tw-px-3 tw-py-2 tw-text-sm tw-border tw-border-gray-300 tw-rounded-lg focus:tw-ring-1 focus:tw-ring-brand-primary focus:tw-border-brand-primary tw-outline-none"
                               placeholder="Buy on Amazon" />
                    </div>
                    <div class="tw-grid tw-grid-cols-2 tw-gap-3">
                        <div>
                            <label class="tw-block tw-text-sm tw-font-medium tw-text-gray-700 tw-mb-1.5">Border Radius <?php echo wp_kses_post( psfa_info_tip('Controls how rounded the button corners are. Use 0 for square, 4px for slightly rounded.') ); ?></label>
                            <input type="text" name="psfa_button_border_radius" value="<?php echo esc_attr($button_border_radius); ?>" 
                                   class="tw-w-full tw-px-3 tw-py-2 tw-text-sm tw-border tw-border-gray-300 tw-rounded-lg focus:tw-ring-1 focus:tw-ring-brand-primary focus:tw-border-brand-primary tw-outline-none"
                                   placeholder="e.g., 4px" />
                        </div>
                        <div>
                            <label class="tw-block tw-text-sm tw-font-medium tw-text-gray-700 tw-mb-1.5">Font Size <?php echo wp_kses_post( psfa_info_tip('Size of the button text. Use CSS units like 14px, 1rem.') ); ?></label>
                            <input type="text" name="psfa_button_font_size" value="<?php echo esc_attr($button_font_size); ?>" 
                                   class="tw-w-full tw-px-3 tw-py-2 tw-text-sm tw-border tw-border-gray-300 tw-rounded-lg focus:tw-ring-1 focus:tw-ring-brand-primary focus:tw-border-brand-primary tw-outline-none"
                                   placeholder="e.g., 14px" />
                        </div>
                    </div>
                    <div>
                        <label class="tw-block tw-text-sm tw-font-medium tw-text-gray-700 tw-mb-1.5">Font Weight <?php echo wp_kses_post( psfa_info_tip('Controls how bold the button text appears.') ); ?></label>
                        <select name="psfa_button_font_weight" class="tw-w-full tw-px-3 tw-py-2 tw-text-sm tw-border tw-border-gray-300 tw-rounded-lg focus:tw-ring-1 focus:tw-ring-brand-primary focus:tw-border-brand-primary tw-outline-none tw-bg-white">
                            <option value="">Default</option>
                            <option value="300" <?php selected($button_font_weight, '300'); ?>>Light (300)</option>
                            <option value="400" <?php selected($button_font_weight, '400'); ?>>Normal (400)</option>
                            <option value="500" <?php selected($button_font_weight, '500'); ?>>Medium (500)</option>
                            <option value="600" <?php selected($button_font_weight, '600'); ?>>Semi-Bold (600)</option>
                            <option value="700" <?php selected($button_font_weight, '700'); ?>>Bold (700)</option>
                        </select>
                    </div>
                </div>
                <?php else : ?>
                <ul class="tw-text-sm tw-text-gray-600 tw-m-0 tw-mb-4 tw-pl-5 tw-space-y-1" style="list-style: disc;">
                    <li>Custom button text</li>
                    <li>Border radius control</li>
                    <li>Font size & weight options</li>
                </ul>
                <a href="<?php echo esc_url($upgrade_url); ?>" target="_blank" 
                   class="tw-inline-flex tw-items-center tw-px-3 tw-py-1.5 tw-text-xs tw-font-medium tw-text-brand-primary tw-bg-blue-50 tw-rounded-lg hover:tw-bg-blue-100 tw-transition-colors tw-no-underline focus:tw-outline-none">
                    Upgrade
                </a>
                <?php endif; ?>
            </div>
            
            <!-- Card Layout Card -->
            <div class="tw-bg-white tw-rounded-xl tw-border tw-border-gray-200 tw-shadow-sm tw-p-5">
                <div class="tw-flex tw-items-center tw-gap-2 tw-mb-4">
                    <h3 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0">Product Card Layout</h3>
                    <span class="tw-px-2 tw-py-0.5 tw-text-xs tw-font-medium tw-border tw-border-solid tw-border-gray-300 tw-bg-gray-100 tw-text-gray-600 tw-rounded">Premium</span>
                </div>
                <p class="tw-text-sm tw-text-gray-500 tw-m-0 tw-mb-4">Choose how product cards are displayed.</p>
                
                <?php if ($is_premium) : ?>
                <div>
                    <label class="tw-block tw-text-sm tw-font-medium tw-text-gray-700 tw-mb-1.5">Card Layout <?php echo wp_kses_post( psfa_info_tip('Default: balanced. Compact: smaller cards. Detailed: more info. Image Focused: larger images.') ); ?></label>
                    <select name="psfa_card_layout" class="tw-w-full tw-px-3 tw-py-2 tw-text-sm tw-border tw-border-gray-300 tw-rounded-lg focus:tw-ring-1 focus:tw-ring-brand-primary focus:tw-border-brand-primary tw-outline-none tw-bg-white">
                        <option value="default" <?php selected($card_layout, 'default'); ?>>Default</option>
                        <option value="compact" <?php selected($card_layout, 'compact'); ?>>Compact</option>
                        <option value="detailed" <?php selected($card_layout, 'detailed'); ?>>Detailed</option>
                        <option value="image_focused" <?php selected($card_layout, 'image_focused'); ?>>Image Focused</option>
                    </select>
                </div>
                <?php else : ?>
                <ul class="tw-text-sm tw-text-gray-600 tw-m-0 tw-mb-4 tw-pl-5 tw-space-y-1" style="list-style: disc;">
                    <li>Default - balanced layout</li>
                    <li>Compact - smaller cards, more per row</li>
                    <li>Detailed - shows more product info</li>
                    <li>Image Focused - larger product images</li>
                </ul>
                <a href="<?php echo esc_url($upgrade_url); ?>" target="_blank" 
                   class="tw-inline-flex tw-items-center tw-px-3 tw-py-1.5 tw-text-xs tw-font-medium tw-text-brand-primary tw-bg-blue-50 tw-rounded-lg hover:tw-bg-blue-100 tw-transition-colors tw-no-underline focus:tw-outline-none">
                    Upgrade
                </a>
                <?php endif; ?>
            </div>
            
            <!-- Font Customization Card -->
            <div class="tw-bg-white tw-rounded-xl tw-border tw-border-gray-200 tw-shadow-sm tw-p-5">
                <div class="tw-flex tw-items-center tw-gap-2 tw-mb-4">
                    <h3 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0">Font Customization</h3>
                    <span class="tw-px-2 tw-py-0.5 tw-text-xs tw-font-medium tw-border tw-border-solid tw-border-gray-300 tw-bg-gray-100 tw-text-gray-600 tw-rounded">Premium</span>
                </div>
                <p class="tw-text-sm tw-text-gray-500 tw-m-0 tw-mb-4">Choose custom fonts for product display elements.</p>
                
                <?php if ($is_premium) : ?>
                <div class="tw-space-y-4">
                    <div>
                        <label class="tw-block tw-text-sm tw-font-medium tw-text-gray-700 tw-mb-1.5">Title Font <?php echo wp_kses_post( psfa_info_tip('Font used for product titles. Google Fonts are loaded automatically.') ); ?></label>
                        <select name="psfa_title_font" class="tw-w-full tw-px-3 tw-py-2 tw-text-sm tw-border tw-border-gray-300 tw-rounded-lg focus:tw-ring-1 focus:tw-ring-brand-primary focus:tw-border-brand-primary tw-outline-none tw-bg-white">
                            <?php foreach ($google_fonts as $font_value => $font_label) : ?>
                            <option value="<?php echo esc_attr($font_value); ?>" <?php selected($title_font, $font_value); ?>><?php echo esc_html($font_label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label class="tw-block tw-text-sm tw-font-medium tw-text-gray-700 tw-mb-1.5">Description Font <?php echo wp_kses_post( psfa_info_tip('Font used for product descriptions and features.') ); ?></label>
                        <select name="psfa_description_font" class="tw-w-full tw-px-3 tw-py-2 tw-text-sm tw-border tw-border-gray-300 tw-rounded-lg focus:tw-ring-1 focus:tw-ring-brand-primary focus:tw-border-brand-primary tw-outline-none tw-bg-white">
                            <?php foreach ($google_fonts as $font_value => $font_label) : ?>
                            <option value="<?php echo esc_attr($font_value); ?>" <?php selected($description_font, $font_value); ?>><?php echo esc_html($font_label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label class="tw-block tw-text-sm tw-font-medium tw-text-gray-700 tw-mb-1.5">Price Font <?php echo wp_kses_post( psfa_info_tip('Font used for product prices.') ); ?></label>
                        <select name="psfa_price_font" class="tw-w-full tw-px-3 tw-py-2 tw-text-sm tw-border tw-border-gray-300 tw-rounded-lg focus:tw-ring-1 focus:tw-ring-brand-primary focus:tw-border-brand-primary tw-outline-none tw-bg-white">
                            <?php foreach ($google_fonts as $font_value => $font_label) : ?>
                            <option value="<?php echo esc_attr($font_value); ?>" <?php selected($price_font, $font_value); ?>><?php echo esc_html($font_label); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <?php else : ?>
                <ul class="tw-text-sm tw-text-gray-600 tw-m-0 tw-mb-4 tw-pl-5 tw-space-y-1" style="list-style: disc;">
                    <li>Custom title fonts from Google Fonts</li>
                    <li>Custom description fonts</li>
                    <li>Custom price fonts</li>
                    <li>10+ popular font choices</li>
                </ul>
                <a href="<?php echo esc_url($upgrade_url); ?>" target="_blank" 
                   class="tw-inline-flex tw-items-center tw-px-3 tw-py-1.5 tw-text-xs tw-font-medium tw-text-brand-primary tw-bg-blue-50 tw-rounded-lg hover:tw-bg-blue-100 tw-transition-colors tw-no-underline focus:tw-outline-none">
                    Upgrade
                </a>
                <?php endif; ?>
            </div>
            
            <!-- Theme Colors Card -->
            <div class="tw-bg-white tw-rounded-xl tw-border tw-border-gray-200 tw-shadow-sm tw-p-5">
                <div class="tw-flex tw-items-center tw-gap-2 tw-mb-4">
                    <h3 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0">Custom Color Schemes</h3>
                    <span class="tw-px-2 tw-py-0.5 tw-text-xs tw-font-medium tw-border tw-border-solid tw-border-gray-300 tw-bg-gray-100 tw-text-gray-600 tw-rounded">Premium</span>
                </div>
                <p class="tw-text-sm tw-text-gray-500 tw-m-0 tw-mb-4">
                    Customize colors for: <strong><?php echo esc_html($themes[$selected_theme]['name'] ?? $selected_theme); ?></strong>
                </p>
                
                <?php if ($is_premium) : ?>
                <?php
                if (isset($themes[$selected_theme])) {
                    $theme_slug = $selected_theme;
                    $current_colors = isset($theme_colors[$theme_slug]) ? $theme_colors[$theme_slug] : array();
                    $default_colors = psfa_get_theme_default_colors($theme_slug);
                    
                    $color_fields = array(
                        'primary_color' => array('label' => 'Primary Color', 'tip' => 'Main accent color for borders and highlights.'),
                        'secondary_color' => array('label' => 'Secondary Color', 'tip' => 'Used for backgrounds and hover states.'),
                        'button_bg' => array('label' => 'Button Background', 'tip' => 'Background color for the buy button.'),
                        'button_text' => array('label' => 'Button Text', 'tip' => 'Text color for the buy button.'),
                        'text_color' => array('label' => 'Text Color', 'tip' => 'Main text color for product info.'),
                        'price_color' => array('label' => 'Price Color', 'tip' => 'Color for product prices.'),
                    );
                    ?>
                    <div class="tw-grid tw-grid-cols-2 tw-gap-4">
                        <?php foreach ($color_fields as $color_key => $color_data) :
                            $current_value = isset($current_colors[$color_key]) && '' !== $current_colors[$color_key] ? $current_colors[$color_key] : '';
                            $default_value = $default_colors[$color_key] ?? '';
                        ?>
                        <div class="tw-flex tw-items-center tw-justify-between tw-gap-3 tw-relative">
                            <label class="tw-text-sm tw-font-medium tw-text-gray-700"><?php echo esc_html($color_data['label']); ?> <?php echo wp_kses_post( psfa_info_tip($color_data['tip']) ); ?></label>
                            <input type="text" 
                                   name="psfa_theme_colors[<?php echo esc_attr($theme_slug); ?>][<?php echo esc_attr($color_key); ?>]" 
                                   value="<?php echo esc_attr($current_value); ?>" 
                                   class="psfa-color-picker" 
                                   data-default-color="<?php echo esc_attr($default_value); ?>" />
                        </div>
                        <?php endforeach; ?>
                    </div>
                    <?php
                }
                ?>
                <?php else : ?>
                <ul class="tw-text-sm tw-text-gray-600 tw-m-0 tw-mb-4 tw-pl-5 tw-space-y-1" style="list-style: disc;">
                    <li>Primary & secondary colors</li>
                    <li>Button background & text colors</li>
                    <li>Text & price colors</li>
                    <li>Per-theme color customization</li>
                </ul>
                <a href="<?php echo esc_url($upgrade_url); ?>" target="_blank" 
                   class="tw-inline-flex tw-items-center tw-px-3 tw-py-1.5 tw-text-xs tw-font-medium tw-text-brand-primary tw-bg-blue-50 tw-rounded-lg hover:tw-bg-blue-100 tw-transition-colors tw-no-underline focus:tw-outline-none">
                    Upgrade
                </a>
                <?php endif; ?>
            </div>
            
        </div>
        
        <!-- Save Buttons (Premium only) -->
        <?php if ($is_premium) : ?>
        <div class="tw-flex tw-gap-3">
            <button type="submit" class="tw-px-5 tw-py-2.5 tw-bg-brand-primary tw-text-white tw-text-sm tw-font-medium tw-rounded-lg hover:tw-bg-brand-hover tw-transition-colors tw-cursor-pointer tw-border-0">
                Save Customization
            </button>
            <a href="<?php echo esc_url(wp_nonce_url(add_query_arg(array('page' => 'paapi-product-search-for-amazon', 'section' => 'customization', 'psfa_reset_customization' => '1'), admin_url('admin.php')), 'psfa_reset_customization')); ?>" 
               class="tw-px-5 tw-py-2.5 tw-bg-white tw-text-gray-700 tw-text-sm tw-font-medium tw-rounded-lg tw-border tw-border-gray-300 hover:tw-bg-gray-50 tw-transition-colors tw-no-underline focus:tw-outline-none"
               onclick="return confirm('Reset all customization settings to defaults?');">
                Reset to Defaults
            </a>
        </div>
        <?php endif; ?>
    </form>
    
    <?php
    // Enqueue WordPress color picker for premium users
    if ($is_premium) {
        wp_enqueue_style('wp-color-picker');
        wp_enqueue_script('wp-color-picker');
        ?>
        <script>
        jQuery(document).ready(function($) {
            if ($.fn.wpColorPicker) {
                $('.psfa-color-picker').each(function() {
                    var $input = $(this);
                    var currentValue = $input.val();
                    var defaultColor = $input.data('default-color') || '';
                    if (!currentValue && defaultColor) {
                        $input.val(defaultColor);
                    }
                    $input.wpColorPicker();
                });
                $('form').on('submit', function() {
                    $('.psfa-color-picker').each(function() {
                        var $input = $(this);
                        var currentValue = $input.val();
                        var defaultColor = $input.data('default-color') || '';
                        if (currentValue && currentValue === defaultColor) {
                            $input.val('');
                        }
                    });
                });
            }
            
            // Trigger custom event after customization section is initialized
            $(document).trigger('psfa_customization_init');
        });
        </script>
        <?php
        // Action hook for adding custom JS after customization section initialization
        do_action( 'psfa_after_customization_scripts' );
        ?>
        <style>
            .wp-picker-container span.wp-color-result-text { display: none; }
            .wp-picker-container .wp-color-result.button { border-radius: 100%; }
        </style>
        <?php
    }
}
