<?php

/**
 * Admin Credentials Section
 *
 * Renders the API credentials form with auth type selection.
 */
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Render credentials section
 */
function psfa_render_credentials()
{
    // Welcome video ID - filterable for easy updates without rebuilding
    $welcome_video_id = apply_filters('psfa_welcome_video_id', 'y2XQCBLj1Sk');
    
    // AWS Sig V4 credentials
    $access_key = get_option('psfa_access_key_id', '');
    $secret_key = get_option('psfa_secret_access_key', '');
    $associate_tag = get_option('psfa_associate_tag', '');

    // OAuth credentials
    $auth_type = get_option('psfa_auth_type', 'awssig4');
    $oauth_client_id = get_option('psfa_oauth_client_id', '');
    $oauth_client_secret = get_option('psfa_oauth_client_secret', '');
    $oauth_credential_version = get_option('psfa_oauth_credential_version', '');
    $oauth_auth_region = get_option('psfa_oauth_auth_region', 'us-east-1');
    $marketplace = get_option('psfa_marketplace', 'www.amazon.com');
    
    // Check if credentials are configured
    $has_credentials = false;
    if ($auth_type === 'oauth') {
        $has_credentials = !empty($oauth_client_id) && !empty($oauth_client_secret);
    } else {
        $has_credentials = !empty($access_key) && !empty($secret_key);
    }
    ?>
    
    <?php if (!$has_credentials) : ?>
    <!-- Welcome Section with Setup Video - Two Columns -->
    <div class="tw-bg-gradient-to-r tw-from-amber-50 tw-to-orange-50 tw-rounded-xl tw-border tw-border-amber-200 tw-shadow-sm tw-overflow-hidden tw-mb-6">
        <div class="tw-p-6">
            <div class="tw-flex tw-flex-col lg:tw-flex-row lg:tw-justify-between tw-gap-6">
                <!-- Left Column: Text & Buttons -->
                <div class="lg:tw-w-1/2 tw-flex tw-flex-col tw-justify-center">
                    <div class="tw-flex tw-items-center tw-gap-3 tw-mb-3">
                        <div class="tw-flex-shrink-0 tw-w-10 tw-h-10 tw-bg-amber-100 tw-rounded-full tw-flex tw-items-center tw-justify-center">
                            <span class="tw-text-xl">👋</span>
                        </div>
                        <h2 class="tw-text-lg tw-font-semibold tw-text-gray-900 tw-m-0">Welcome!</h2>
                    </div>
                    <p class="tw-text-gray-600 tw-mb-4 tw-text-sm">Get started in just a few minutes. Watch this quick setup guide to configure your API credentials and start earning with Amazon affiliate links.</p>
                    
                    <div class="tw-flex tw-flex-col tw-gap-2">
                        <a href="https://affiliate-program.amazon.com/creatorsapi" target="_blank" class="tw-inline-flex tw-items-center tw-justify-between tw-px-4 tw-py-2.5 tw-bg-white tw-border tw-border-gray-300 tw-rounded-lg tw-text-sm tw-font-medium tw-text-gray-700 hover:tw-bg-gray-50 tw-no-underline tw-transition-colors">
                            <span class="tw-inline-flex tw-items-center tw-gap-2">
                                <svg class="tw-w-4 tw-h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2"><path stroke-linecap="round" stroke-linejoin="round" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14" /></svg>
                                Get Creators API Credentials
                            </span>
                            <span class="tw-px-2 tw-py-0.5 tw-text-[10px] tw-font-semibold tw-bg-green-100 tw-text-green-700 tw-rounded-full tw-uppercase">Recommended</span>
                        </a>
                        <a href="https://affiliate-program.amazon.com/assoc_credentials/home" target="_blank" class="tw-inline-flex tw-items-center tw-gap-2 tw-px-4 tw-py-2.5 tw-bg-white tw-border tw-border-gray-300 tw-rounded-lg tw-text-sm tw-font-medium tw-text-gray-700 hover:tw-bg-gray-50 tw-no-underline tw-transition-colors">
                            <svg class="tw-w-4 tw-h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2"><path stroke-linecap="round" stroke-linejoin="round" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14" /></svg>
                            Get PA-API Credentials
                        </a>
                    </div>
                </div>
                
                <!-- Right Column: Video -->
                <div class="lg:tw-w-2/5">
                    <div id="psfa-welcome-video" class="tw-relative tw-w-full tw-rounded-lg tw-overflow-hidden tw-shadow-md tw-cursor-pointer tw-group" style="padding-bottom: 56.25%; height: 0; background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);">
                        <!-- Video Thumbnail -->
                        <img 
                            src="https://img.youtube.com/vi/<?php echo esc_attr($welcome_video_id); ?>/maxresdefault.jpg" 
                            alt="Setup Guide Video" 
                            class="tw-absolute tw-top-0 tw-left-0 tw-w-full tw-h-full tw-object-cover"
                            onerror="this.src='https://img.youtube.com/vi/<?php echo esc_attr($welcome_video_id); ?>/hqdefault.jpg'"
                        />
                        <!-- Dark Overlay -->
                        <div class="tw-absolute tw-inset-0 tw-bg-black tw-bg-opacity-30 group-hover:tw-bg-opacity-40 tw-transition-all"></div>
                        <!-- Play Button -->
                        <div class="tw-absolute tw-inset-0 tw-flex tw-items-center tw-justify-center">
                            <div class="tw-w-16 tw-h-16 tw-bg-brand-primary tw-rounded-full tw-flex tw-items-center tw-justify-center tw-shadow-lg group-hover:tw-scale-110 tw-transition-transform">
                                <svg class="tw-w-6 tw-h-6 tw-text-white tw-ml-1" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M8 5v14l11-7z"/>
                                </svg>
                            </div>
                        </div>
                    </div>
                    <script>
                    (function() {
                        var psfaYtApiReady = false;
                        var psfaPendingPlayer = null;
                        var originalOnReady = window.onYouTubeIframeAPIReady;

                        window.onYouTubeIframeAPIReady = function() {
                            psfaYtApiReady = true;
                            if (originalOnReady) originalOnReady();
                            if (psfaPendingPlayer) {
                                createPsfaPlayer(psfaPendingPlayer.overlay, psfaPendingPlayer.iframe);
                                psfaPendingPlayer = null;
                            }
                        };

                        function createPsfaPlayer(overlay, iframe) {
                            new YT.Player(iframe, {
                                events: {
                                    'onStateChange': function(event) {
                                        if (event.data === YT.PlayerState.ENDED) {
                                            overlay.classList.remove('psfa-playing');
                                            var oldIframe = overlay.querySelector('iframe');
                                            if (oldIframe) oldIframe.remove();
                                        }
                                    }
                                }
                            });
                        }

                        // Load YouTube API if not already loaded
                        if (!document.querySelector('script[src*="youtube.com/iframe_api"]')) {
                            var tag = document.createElement('script');
                            tag.src = 'https://www.youtube.com/iframe_api';
                            var firstScript = document.getElementsByTagName('script')[0];
                            firstScript.parentNode.insertBefore(tag, firstScript);
                        } else if (typeof YT !== 'undefined' && YT.Player) {
                            psfaYtApiReady = true;
                        }

                        var overlay = document.getElementById('psfa-welcome-video');
                        overlay.addEventListener('click', function(e) {
                            if (this.classList.contains('psfa-playing')) return;
                            
                            var iframe = document.createElement('iframe');
                            iframe.src = 'https://www.youtube.com/embed/<?php echo esc_js($welcome_video_id); ?>?autoplay=1&enablejsapi=1&rel=0&vq=hd1080';
                            iframe.title = 'Setup Guide';
                            iframe.allow = 'accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture';
                            iframe.allowFullscreen = true;
                            iframe.className = 'tw-absolute tw-top-0 tw-left-0 tw-w-full tw-h-full tw-rounded-lg';
                            iframe.style.border = 'none';
                            this.appendChild(iframe);
                            this.classList.add('psfa-playing');

                            if (psfaYtApiReady) {
                                createPsfaPlayer(this, iframe);
                            } else {
                                psfaPendingPlayer = { overlay: this, iframe: iframe };
                            }
                        });
                    })();
                    </script>
                    <style>
                    #psfa-welcome-video.psfa-playing > *:not(iframe) { visibility: hidden; }
                    #psfa-welcome-video.psfa-playing { cursor: default; }
                    </style>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    
    <div class="tw-flex tw-flex-col lg:tw-flex-row tw-gap-6 tw-items-start">
        <!-- Credentials Card -->
        <form action="options.php" method="post" class="lg:tw-w-1/2">
            <?php settings_fields('psfa_settings'); ?>
            <?php
            // Preserve all other settings
            $saved_features = get_option('psfa_features', array());
            $selected_theme = get_option('psfa_selected_theme', 'amazon-inspired');
            $display_mode = get_option('psfa_display_mode', 'grid');
            $hide_banner = get_option('psfa_hide_category_banner', false);
            $hide_search = in_array(get_option('psfa_hide_search', '0'), array('1', 1, true, 'true'), true);
            $hide_filters = in_array(get_option('psfa_hide_filters', '0'), array('1', 1, true, 'true'), true);
            $filter_visibility = get_option('psfa_filter_visibility', array());
            $button_text = get_option('psfa_button_text', 'Buy on Amazon');
            $button_border_radius = get_option('psfa_button_border_radius', '');
            $button_font_size = get_option('psfa_button_font_size', '');
            $button_font_weight = get_option('psfa_button_font_weight', '');
            $card_layout = get_option('psfa_card_layout', 'default');
            $title_font = get_option('psfa_title_font', '');
            $description_font = get_option('psfa_description_font', '');
            $price_font = get_option('psfa_price_font', '');
            $theme_colors = get_option('psfa_theme_colors', array());
            ?>
            <input type="hidden" name="psfa_selected_theme" value="<?php echo esc_attr($selected_theme); ?>">
            <input type="hidden" name="psfa_display_mode" value="<?php echo esc_attr($display_mode); ?>">
            <input type="hidden" name="psfa_hide_category_banner" value="<?php echo $hide_banner ? '1' : '0'; ?>">
            <input type="hidden" name="psfa_hide_search" value="<?php echo $hide_search ? '1' : '0'; ?>">
            <input type="hidden" name="psfa_hide_filters" value="<?php echo $hide_filters ? '1' : '0'; ?>">
            <?php foreach ($filter_visibility as $fk => $fv): ?>
            <input type="hidden" name="psfa_filter_visibility[<?php echo esc_attr($fk); ?>]" value="<?php echo $fv ? '1' : '0'; ?>">
            <?php endforeach; ?>
            <input type="hidden" name="psfa_button_text" value="<?php echo esc_attr($button_text); ?>">
            <input type="hidden" name="psfa_button_border_radius" value="<?php echo esc_attr($button_border_radius); ?>">
            <input type="hidden" name="psfa_button_font_size" value="<?php echo esc_attr($button_font_size); ?>">
            <input type="hidden" name="psfa_button_font_weight" value="<?php echo esc_attr($button_font_weight); ?>">
            <input type="hidden" name="psfa_card_layout" value="<?php echo esc_attr($card_layout); ?>">
            <input type="hidden" name="psfa_title_font" value="<?php echo esc_attr($title_font); ?>">
            <input type="hidden" name="psfa_description_font" value="<?php echo esc_attr($description_font); ?>">
            <input type="hidden" name="psfa_price_font" value="<?php echo esc_attr($price_font); ?>">
            <?php foreach ($theme_colors as $theme_slug => $colors):
                foreach ($colors as $ck => $cv): ?>
            <input type="hidden" name="psfa_theme_colors[<?php echo esc_attr($theme_slug); ?>][<?php echo esc_attr($ck); ?>]" value="<?php echo esc_attr($cv); ?>">
            <?php endforeach;
            endforeach; ?>
            <?php foreach ($saved_features as $fkey => $fval): ?>
            <input type="hidden" name="psfa_features[<?php echo esc_attr($fkey); ?>]" value="<?php echo $fval ? '1' : '0'; ?>">
            <?php endforeach; ?>
            <div class="tw-bg-white tw-rounded-xl tw-border tw-border-gray-200 tw-shadow-sm tw-overflow-hidden">
            <div class="tw-px-6 tw-py-5 tw-border-b tw-border-gray-200">
                <h2 class="tw-flex tw-items-center tw-gap-2 tw-text-base tw-font-semibold tw-text-gray-900 tw-m-0">
                    <svg class="tw-w-5 tw-h-5 tw-text-brand-primary" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z" />
                    </svg>
                    Amazon API Credentials
                </h2>
                <p class="tw-mt-1 tw-text-sm tw-text-gray-500 tw-m-0">Choose your authentication method and enter your credentials.</p>
            </div>
            <div class="tw-p-6 tw-space-y-5">
                <!-- Auth Type Selector -->
                <div class="tw-space-y-3">
                    <label class="tw-block tw-text-sm tw-font-medium tw-text-gray-700">Authentication Method</label>
                    <div class="tw-space-y-2">
                        <label class="tw-flex tw-items-start tw-gap-3 tw-p-3 tw-border tw-rounded-lg tw-cursor-pointer <?php echo $auth_type === 'oauth' ? 'tw-border-brand-primary tw-bg-blue-50' : 'tw-border-gray-200 hover:tw-border-gray-300'; ?>" id="psfa-auth-oauth-label">
                            <input type="radio" name="psfa_auth_type" value="oauth" <?php checked($auth_type, 'oauth'); ?> 
                                   class="tw-mt-0.5" id="psfa-auth-oauth" onchange="psfaToggleAuthFields()">
                            <div>
                                <span class="tw-text-sm tw-font-medium tw-text-gray-900">OAuth 2.0 (Creators API)</span>
                                <span class="tw-ml-2 tw-px-2 tw-py-0.5 tw-text-xs tw-font-medium tw-bg-green-100 tw-text-green-700 tw-rounded">RECOMMENDED</span>
                                <p class="tw-text-xs tw-text-gray-500 tw-mt-0.5 tw-mb-0">New authentication method with Creators API. Get credentials from <a href="https://affiliate-program.amazon.com/creatorsapi/docs/en-us/onboarding/register-for-creators-api" target="_blank" class="tw-text-brand-primary">Associates Central</a>.</p>
                            </div>
                        </label>
                        <label class="tw-flex tw-items-start tw-gap-3 tw-p-3 tw-border tw-rounded-lg tw-cursor-pointer <?php echo $auth_type === 'awssig4' ? 'tw-border-brand-primary tw-bg-blue-50' : 'tw-border-gray-200 hover:tw-border-gray-300'; ?>" id="psfa-auth-awssig4-label">
                            <input type="radio" name="psfa_auth_type" value="awssig4" <?php checked($auth_type, 'awssig4'); ?> 
                                   class="tw-mt-0.5" id="psfa-auth-awssig4" onchange="psfaToggleAuthFields()">
                            <div>
                                <span class="tw-text-sm tw-font-medium tw-text-gray-900">AWS Signature V4 (Legacy PA-API)</span>
                                <p class="tw-text-xs tw-text-gray-500 tw-mt-0.5 tw-mb-0">Traditional authentication using Access Key ID and Secret Key.</p>
                            </div>
                        </label>
                    </div>
                </div>

                <!-- OAuth Fields -->
                <div id="psfa-oauth-fields" class="tw-space-y-4 <?php echo $auth_type !== 'oauth' ? 'tw-hidden' : ''; ?>">
                    <div class="tw-pt-2 tw-border-t tw-border-gray-100">
                        <div class="tw-space-y-4">
                            <div>
                                <label for="psfa_oauth_client_id" class="tw-block tw-text-sm tw-font-medium tw-text-gray-700 tw-mb-1.5">Credential ID</label>
                                <input type="text" name="psfa_oauth_client_id" id="psfa_oauth_client_id" 
                                       value="<?php echo esc_attr($oauth_client_id); ?>" 
                                       class="tw-w-full tw-max-w-md tw-px-3 tw-py-2 tw-text-sm tw-border tw-border-gray-300 tw-rounded-lg focus:tw-ring-1 focus:tw-ring-brand-primary focus:tw-border-brand-primary tw-outline-none"
                                       placeholder="Your credential_id from Creators API"
                                       autocomplete="off" />
                            </div>
                            <div>
                                <label for="psfa_oauth_client_secret" class="tw-block tw-text-sm tw-font-medium tw-text-gray-700 tw-mb-1.5">Credential Secret</label>
                                <input type="password" name="psfa_oauth_client_secret" id="psfa_oauth_client_secret" 
                                       value="<?php echo esc_attr($oauth_client_secret); ?>" 
                                       class="tw-w-full tw-max-w-md tw-px-3 tw-py-2 tw-text-sm tw-border tw-border-gray-300 tw-rounded-lg focus:tw-ring-1 focus:tw-ring-brand-primary focus:tw-border-brand-primary tw-outline-none"
                                       placeholder="Your credential_secret"
                                       autocomplete="new-password" />
                            </div>
                            <div class="tw-grid tw-grid-cols-2 tw-gap-4">
                                <div>
                                    <label for="psfa_oauth_credential_version" class="tw-block tw-text-sm tw-font-medium tw-text-gray-700 tw-mb-1.5">Credential Version</label>
                                    <input type="text" name="psfa_oauth_credential_version" id="psfa_oauth_credential_version" 
                                           value="<?php echo esc_attr($oauth_credential_version); ?>" 
                                           class="tw-w-full tw-px-3 tw-py-2 tw-text-sm tw-border tw-border-gray-300 tw-rounded-lg focus:tw-ring-1 focus:tw-ring-brand-primary focus:tw-border-brand-primary tw-outline-none"
                                           placeholder="e.g., 2.1"
                                           autocomplete="off" />
                                </div>
                                <div>
                                    <label for="psfa_oauth_auth_region" class="tw-block tw-text-sm tw-font-medium tw-text-gray-700 tw-mb-1.5">Auth Region</label>
                                    <select name="psfa_oauth_auth_region" id="psfa_oauth_auth_region" 
                                            class="tw-w-full tw-px-3 tw-py-2 tw-text-sm tw-border tw-border-gray-300 tw-rounded-lg focus:tw-ring-1 focus:tw-ring-brand-primary focus:tw-border-brand-primary tw-outline-none">
                                        <option value="us-east-1" <?php selected($oauth_auth_region, 'us-east-1'); ?>>us-east-1 (US)</option>
                                        <option value="us-west-2" <?php selected($oauth_auth_region, 'us-west-2'); ?>>us-west-2</option>
                                        <option value="eu-west-1" <?php selected($oauth_auth_region, 'eu-west-1'); ?>>eu-west-1 (Europe)</option>
                                        <option value="ap-northeast-1" <?php selected($oauth_auth_region, 'ap-northeast-1'); ?>>ap-northeast-1 (Japan)</option>
                                    </select>
                                </div>
                            </div>
                            <div>
                                <label for="psfa_marketplace" class="tw-block tw-text-sm tw-font-medium tw-text-gray-700 tw-mb-1.5">Marketplace</label>
                                <select name="psfa_marketplace" id="psfa_marketplace" 
                                        class="tw-w-full tw-max-w-md tw-px-3 tw-py-2 tw-text-sm tw-border tw-border-gray-300 tw-rounded-lg focus:tw-ring-1 focus:tw-ring-brand-primary focus:tw-border-brand-primary tw-outline-none">
                                    <option value="www.amazon.com" <?php selected($marketplace, 'www.amazon.com'); ?>>www.amazon.com (US)</option>
                                    <option value="www.amazon.co.uk" <?php selected($marketplace, 'www.amazon.co.uk'); ?>>www.amazon.co.uk (UK)</option>
                                    <option value="www.amazon.de" <?php selected($marketplace, 'www.amazon.de'); ?>>www.amazon.de (Germany)</option>
                                    <option value="www.amazon.fr" <?php selected($marketplace, 'www.amazon.fr'); ?>>www.amazon.fr (France)</option>
                                    <option value="www.amazon.ca" <?php selected($marketplace, 'www.amazon.ca'); ?>>www.amazon.ca (Canada)</option>
                                    <option value="www.amazon.co.jp" <?php selected($marketplace, 'www.amazon.co.jp'); ?>>www.amazon.co.jp (Japan)</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- AWS Sig V4 Fields -->
                <div id="psfa-awssig4-fields" class="tw-space-y-4 <?php echo $auth_type !== 'awssig4' ? 'tw-hidden' : ''; ?>">
                    <div class="tw-pt-2 tw-border-t tw-border-gray-100">
                        <div class="tw-space-y-4">
                            <div>
                                <label for="psfa_access_key_id" class="tw-block tw-text-sm tw-font-medium tw-text-gray-700 tw-mb-1.5">Access Key ID</label>
                                <input type="text" name="psfa_access_key_id" id="psfa_access_key_id" 
                                       value="<?php echo esc_attr($access_key); ?>" 
                                       class="tw-w-full tw-max-w-md tw-px-3 tw-py-2 tw-text-sm tw-border tw-border-gray-300 tw-rounded-lg focus:tw-ring-1 focus:tw-ring-brand-primary focus:tw-border-brand-primary tw-outline-none"
                                       placeholder="Enter your Access Key ID"
                                       autocomplete="off" />
                            </div>
                            <div>
                                <label for="psfa_secret_access_key" class="tw-block tw-text-sm tw-font-medium tw-text-gray-700 tw-mb-1.5">Secret Access Key</label>
                                <input type="password" name="psfa_secret_access_key" id="psfa_secret_access_key" 
                                       value="<?php echo esc_attr($secret_key); ?>" 
                                       class="tw-w-full tw-max-w-md tw-px-3 tw-py-2 tw-text-sm tw-border tw-border-gray-300 tw-rounded-lg focus:tw-ring-1 focus:tw-ring-brand-primary focus:tw-border-brand-primary tw-outline-none"
                                       placeholder="Enter your Secret Access Key"
                                       autocomplete="new-password" />
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Associate Tag (shared) -->
                <div>
                    <label for="psfa_associate_tag" class="tw-block tw-text-sm tw-font-medium tw-text-gray-700 tw-mb-1.5">Associate Tag</label>
                    <input type="text" name="psfa_associate_tag" id="psfa_associate_tag" 
                           value="<?php echo esc_attr($associate_tag); ?>" 
                           class="tw-w-full tw-max-w-md tw-px-3 tw-py-2 tw-text-sm tw-border tw-border-gray-300 tw-rounded-lg focus:tw-ring-1 focus:tw-ring-brand-primary focus:tw-border-brand-primary tw-outline-none"
                           placeholder="your-associate-tag"
                           autocomplete="off" />
                </div>
                <div>
                    <span id="psfa-test-result" class="tw-text-sm tw-hidden"></span>
                </div>
            </div>
            <div class="tw-px-6 tw-py-4 tw-bg-gray-50 tw-border-t tw-border-gray-200 tw-flex tw-items-center tw-gap-3">
                <button type="submit" class="tw-px-5 tw-py-2.5 tw-bg-brand-primary tw-text-white tw-text-sm tw-font-medium tw-rounded-lg hover:tw-bg-brand-hover tw-transition-colors tw-cursor-pointer tw-border-0">
                    Save Credentials
                </button>
                <button type="button" id="psfa-test-connection" onclick="psfaTestConnection()" class="tw-px-5 tw-py-2.5 tw-bg-white tw-text-gray-700 tw-text-sm tw-font-medium tw-rounded-lg tw-border tw-border-gray-300 hover:tw-bg-gray-50 tw-transition-colors tw-cursor-pointer">
                        Test Connection
                </button>
            </div>
            </div>
        </form>

        <!-- How to Get Credentials Card -->
        <div class="lg:tw-w-1/2 tw-bg-white tw-rounded-xl tw-border tw-border-gray-200 tw-shadow-sm tw-overflow-hidden tw-self-start">
            <div class="tw-px-6 tw-py-5 tw-border-b tw-border-gray-200">
                <h3 class="tw-flex tw-items-center tw-gap-2 tw-text-base tw-font-semibold tw-text-gray-900 tw-m-0">
                    <svg class="tw-w-5 tw-h-5 tw-text-brand-primary" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z" />
                    </svg>
                    How to Get API Credentials
                </h3>
            </div>
            <div class="tw-p-6 tw-space-y-5">
                <!-- Creators API (Recommended) -->
                <div>
                    <h4 class="tw-flex tw-items-center tw-gap-2 tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0 tw-mb-2">
                        Creators API (OAuth 2.0)
                        <span class="tw-px-2 tw-py-0.5 tw-text-xs tw-font-medium tw-bg-green-100 tw-text-green-700 tw-rounded">RECOMMENDED</span>
                    </h4>
                    <ol class="tw-list-decimal tw-pl-5 tw-space-y-1.5 tw-text-sm tw-text-gray-600 tw-m-0">
                        <li>Join <a href="https://affiliate-program.amazon.com/" target="_blank" class="tw-text-brand-primary hover:tw-underline">Amazon Associates</a> (if not already)</li>
                        <li>Go to <a href="https://affiliate-program.amazon.com/creatorsapi/docs/en-us/onboarding/register-for-creators-api" target="_blank" class="tw-text-brand-primary hover:tw-underline">Creators API Registration</a></li>
                        <li>Click <strong>"Register for Creators API"</strong></li>
                        <li>Copy your <strong>Credential ID</strong>, <strong>Secret</strong>, and <strong>Version</strong></li>
                    </ol>
                    <p class="tw-text-xs tw-text-gray-500 tw-mt-2 tw-mb-0">
                        <strong>Note:</strong> Approval is typically instant. Credentials are shown only once – save them securely!
                    </p>
                </div>

                <hr class="tw-border-gray-200 tw-my-4">

                <!-- Legacy PA-API -->
                <div>
                    <h4 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0 tw-mb-2">
                        Legacy PA-API (AWS Signature V4)
                    </h4>
                    <ol class="tw-list-decimal tw-pl-5 tw-space-y-1.5 tw-text-sm tw-text-gray-600 tw-m-0">
                        <li>Join <a href="https://affiliate-program.amazon.com/" target="_blank" class="tw-text-brand-primary hover:tw-underline">Amazon Associates</a> (if not already)</li>
                        <li>Go to <a href="https://affiliate-program.amazon.com/assoc_credentials/home" target="_blank" class="tw-text-brand-primary hover:tw-underline">PA-API Credentials</a> in Associates Central</li>
                        <li>Click <strong>"Add Credentials"</strong> or <strong>"Manage Credentials"</strong></li>
                        <li>Copy your <strong>Access Key ID</strong> and <strong>Secret Access Key</strong></li>
                    </ol>
                    <p class="tw-text-xs tw-text-gray-500 tw-mt-2 tw-mb-0">
                        <strong>Requirements:</strong> 3 qualifying sales in the last 30 days to get API access. New accounts may need to wait.
                    </p>
                </div>

                <hr class="tw-border-gray-200 tw-my-4">

                <!-- Associate Tag -->
                <div>
                    <h4 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0 tw-mb-2">
                        Associate Tag (Tracking ID)
                    </h4>
                    <p class="tw-text-sm tw-text-gray-600 tw-m-0">
                        Your Associate Tag is your Amazon tracking ID (e.g., <code class="tw-bg-gray-100 tw-px-1 tw-rounded">mysite-20</code>). Find it in 
                        <a href="https://affiliate-program.amazon.com/home/account/tag/manage" target="_blank" class="tw-text-brand-primary hover:tw-underline">Associates Central → Account Settings → Manage Tracking IDs</a>.
                    </p>
                </div>
            </div>
        </div>
    </div>

    <script>
    function psfaTestConnection() {
            var btn = document.getElementById('psfa-test-connection');
            var result = document.getElementById('psfa-test-result');
            var authType = document.querySelector('input[name="psfa_auth_type"]:checked').value;
            
            btn.disabled = true;
            btn.textContent = 'Testing...';
            result.className = 'tw-text-sm tw-hidden';
            result.textContent = '';
            
            var data = new FormData();
            data.append('action', 'psfa_test_connection');
            data.append('nonce', '<?php echo esc_attr(wp_create_nonce('psfa_test_connection')); ?>');
            data.append('auth_type', authType);
            
            if (authType === 'oauth') {
                data.append('client_id', document.getElementById('psfa_oauth_client_id').value);
                data.append('client_secret', document.getElementById('psfa_oauth_client_secret').value);
                data.append('credential_version', document.getElementById('psfa_oauth_credential_version').value);
                data.append('auth_region', document.getElementById('psfa_oauth_auth_region').value);
                data.append('marketplace', document.getElementById('psfa_marketplace').value);
                data.append('associate_tag', document.getElementById('psfa_associate_tag').value);
            } else {
                data.append('access_key', document.getElementById('psfa_access_key_id').value);
                data.append('secret_key', document.getElementById('psfa_secret_access_key').value);
                data.append('associate_tag', document.getElementById('psfa_associate_tag').value);
            }
            
            fetch(ajaxurl, {
                method: 'POST',
                body: data
            })
            .then(function(response) { return response.json(); })
            .then(function(data) {
                btn.disabled = false;
                btn.textContent = 'Test Connection';
                result.classList.remove('tw-hidden');
                if (data.success) {
                    result.className = 'tw-text-sm tw-text-green-600';
                    result.textContent = '✓ ' + data.data.message;
                } else {
                    result.className = 'tw-text-sm tw-text-red-600';
                    result.textContent = '✗ ' + data.data.message;
                }
            })
            .catch(function(err) {
                btn.disabled = false;
                btn.textContent = 'Test Connection';
                result.classList.remove('tw-hidden');
                result.className = 'tw-text-sm tw-text-red-600';
                result.textContent = '✗ Connection error';
            });
        }
        
        function psfaToggleAuthFields() {
            var oauthRadio = document.getElementById('psfa-auth-oauth');
            var oauthFields = document.getElementById('psfa-oauth-fields');
            var awssig4Fields = document.getElementById('psfa-awssig4-fields');
            var oauthLabel = document.getElementById('psfa-auth-oauth-label');
            var awssig4Label = document.getElementById('psfa-auth-awssig4-label');
            
            if (oauthRadio.checked) {
                oauthFields.classList.remove('tw-hidden');
                awssig4Fields.classList.add('tw-hidden');
                oauthLabel.classList.add('tw-border-brand-primary', 'tw-bg-blue-50');
                oauthLabel.classList.remove('tw-border-gray-200');
                awssig4Label.classList.remove('tw-border-brand-primary', 'tw-bg-blue-50');
                awssig4Label.classList.add('tw-border-gray-200');
            } else {
                oauthFields.classList.add('tw-hidden');
                awssig4Fields.classList.remove('tw-hidden');
                awssig4Label.classList.add('tw-border-brand-primary', 'tw-bg-blue-50');
                awssig4Label.classList.remove('tw-border-gray-200');
                oauthLabel.classList.remove('tw-border-brand-primary', 'tw-bg-blue-50');
                oauthLabel.classList.add('tw-border-gray-200');
            }
        }
    </script>
    <?php
}
