<?php
/**
 * Admin Add-ons Promo Section
 * 
 * Shows promo content for add-ons when they are not installed.
 * This allows users to discover available add-ons even without installing them.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Register add-on promo sections if addons are not active
 */
function psfa_register_addons_promo_sections( $sections ) {
    $show_product_boxes = ! class_exists( 'PSFA_Boxes_Admin' ) && ! class_exists( 'PSFA_Boxes_Promo' );
    $show_comparison_tables = ! class_exists( 'PSFA_Tables_Admin' ) && ! class_exists( 'PSFA_Tables_Promo' );
    
    // If both addons are active, nothing to show
    if ( ! $show_product_boxes && ! $show_comparison_tables ) {
        return $sections;
    }
    
    // Add ADD-ONS section
    if ( ! isset( $sections['addons'] ) ) {
        $sections['addons'] = array(
            'label' => 'ADD-ONS',
            'items' => array(),
        );
    }
    
    // Add Product Boxes promo if not active
    if ( $show_product_boxes ) {
        $sections['addons']['items']['product-boxes'] = 'Product Boxes';
    }
    
    // Add Comparison Tables promo if not active
    if ( $show_comparison_tables ) {
        $sections['addons']['items']['comparison-tables'] = 'Comparison Tables';
    }
    
    return $sections;
}

if ( function_exists( 'add_filter' ) ) {
    add_filter( 'psfa_admin_nav_sections', 'psfa_register_addons_promo_sections', 5 );
}

/**
 * Register add-on promo section titles
 */
function psfa_register_addons_promo_titles( $titles ) {
    if ( ! class_exists( 'PSFA_Boxes_Admin' ) && ! class_exists( 'PSFA_Boxes_Promo' ) ) {
        $titles['product-boxes'] = __( 'Product Boxes', 'paapi-product-search-for-amazon' );
    }
    if ( ! class_exists( 'PSFA_Tables_Admin' ) && ! class_exists( 'PSFA_Tables_Promo' ) ) {
        $titles['comparison-tables'] = __( 'Comparison Tables', 'paapi-product-search-for-amazon' );
    }
    return $titles;
}

if ( function_exists( 'add_filter' ) ) {
    add_filter( 'psfa_admin_section_titles', 'psfa_register_addons_promo_titles', 5 );
}

/**
 * Register add-on promo section descriptions
 */
function psfa_register_addons_promo_descriptions( $descriptions ) {
    if ( ! class_exists( 'PSFA_Boxes_Admin' ) && ! class_exists( 'PSFA_Boxes_Promo' ) ) {
        $descriptions['product-boxes'] = __( 'Display individual Amazon products beautifully', 'paapi-product-search-for-amazon' );
    }
    if ( ! class_exists( 'PSFA_Tables_Admin' ) && ! class_exists( 'PSFA_Tables_Promo' ) ) {
        $descriptions['comparison-tables'] = __( 'Create side-by-side product comparison tables', 'paapi-product-search-for-amazon' );
    }
    return $descriptions;
}

if ( function_exists( 'add_filter' ) ) {
    add_filter( 'psfa_admin_section_descriptions', 'psfa_register_addons_promo_descriptions', 5 );
}

/**
 * Render add-on promo sections
 */
function psfa_render_addons_promo_section( $handled, $section, $is_premium ) {
    // Product Boxes promo
    if ( 'product-boxes' === $section ) {
        if ( class_exists( 'PSFA_Boxes_Admin' ) || class_exists( 'PSFA_Boxes_Promo' ) ) {
            return $handled;
        }
        psfa_render_product_boxes_promo();
        return true;
    }
    
    // Comparison Tables promo
    if ( 'comparison-tables' === $section ) {
        if ( class_exists( 'PSFA_Tables_Admin' ) || class_exists( 'PSFA_Tables_Promo' ) ) {
            return $handled;
        }
        psfa_render_comparison_tables_promo();
        return true;
    }
    
    return $handled;
}

if ( function_exists( 'add_filter' ) ) {
    add_filter( 'psfa_render_admin_section', 'psfa_render_addons_promo_section', 5, 3 );
}

/**
 * Render the Product Boxes promo content
 */
function psfa_render_product_boxes_promo() {
    $purchase_url = 'https://paapiplugin.com/product-boxes/';
    $parent_upgrade_url = 'https://paapiplugin.com/pricing/#plans';
    ?>
    <!-- How It Works -->
    <div class="tw-mb-8">
        <h2 class="tw-text-lg tw-font-semibold tw-text-gray-900 tw-m-0 tw-mb-4"><?php esc_html_e( 'How It Works', 'paapi-product-search-for-amazon' ); ?></h2>
        <div class="tw-grid tw-grid-cols-1 md:tw-grid-cols-3 tw-gap-4">
            <div class="tw-bg-white tw-rounded-xl tw-border tw-border-gray-200 tw-shadow-sm tw-p-5">
                <div class="tw-flex tw-items-start tw-gap-3">
                    <div class="tw-flex-shrink-0">
                        <span class="tw-flex tw-items-center tw-justify-center tw-w-6 tw-h-6 tw-bg-blue-100 tw-text-blue-600 tw-rounded-full">
                            <svg class="tw-w-4 tw-h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                            </svg>
                        </span>
                    </div>
                    <div class="tw-flex-1">
                        <div class="tw-flex tw-items-center tw-justify-between tw-gap-2 tw-mb-2">
                            <h3 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0"><?php esc_html_e( 'Search Products', 'paapi-product-search-for-amazon' ); ?></h3>
                            <span class="tw-px-2 tw-py-0.5 tw-text-xs tw-font-medium tw-border tw-border-solid tw-border-gray-300 tw-bg-gray-100 tw-text-gray-700 tw-rounded"><?php esc_html_e( 'Step 1', 'paapi-product-search-for-amazon' ); ?></span>
                        </div>
                        <p class="tw-text-sm tw-text-gray-600 tw-m-0"><?php esc_html_e( 'Visit your search page while logged in as admin.', 'paapi-product-search-for-amazon' ); ?></p>
                    </div>
                </div>
            </div>
            <div class="tw-bg-white tw-rounded-xl tw-border tw-border-gray-200 tw-shadow-sm tw-p-5">
                <div class="tw-flex tw-items-start tw-gap-3">
                    <div class="tw-flex-shrink-0">
                        <span class="tw-flex tw-items-center tw-justify-center tw-w-6 tw-h-6 tw-bg-blue-100 tw-text-blue-600 tw-rounded-full">
                            <svg class="tw-w-4 tw-h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4" />
                            </svg>
                        </span>
                    </div>
                    <div class="tw-flex-1">
                        <div class="tw-flex tw-items-center tw-justify-between tw-gap-2 tw-mb-2">
                            <h3 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0"><?php esc_html_e( 'Click "+ Box"', 'paapi-product-search-for-amazon' ); ?></h3>
                            <span class="tw-px-2 tw-py-0.5 tw-text-xs tw-font-medium tw-border tw-border-solid tw-border-gray-300 tw-bg-gray-100 tw-text-gray-700 tw-rounded"><?php esc_html_e( 'Step 2', 'paapi-product-search-for-amazon' ); ?></span>
                        </div>
                        <p class="tw-text-sm tw-text-gray-600 tw-m-0"><?php esc_html_e( 'Click the "+ Box" button on any product card to save it, Or add it manually.', 'paapi-product-search-for-amazon' ); ?></p>
                    </div>
                </div>
            </div>
            <div class="tw-bg-white tw-rounded-xl tw-border tw-border-gray-200 tw-shadow-sm tw-p-5">
                <div class="tw-flex tw-items-start tw-gap-3">
                    <div class="tw-flex-shrink-0">
                        <span class="tw-flex tw-items-center tw-justify-center tw-w-6 tw-h-6 tw-bg-blue-100 tw-text-blue-600 tw-rounded-full">
                            <svg class="tw-w-4 tw-h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z" />
                            </svg>
                        </span>
                    </div>
                    <div class="tw-flex-1">
                        <div class="tw-flex tw-items-center tw-justify-between tw-gap-2 tw-mb-2">
                            <h3 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0"><?php esc_html_e( 'Use Shortcode', 'paapi-product-search-for-amazon' ); ?></h3>
                            <span class="tw-px-2 tw-py-0.5 tw-text-xs tw-font-medium tw-border tw-border-solid tw-border-gray-300 tw-bg-gray-100 tw-text-gray-700 tw-rounded"><?php esc_html_e( 'Step 3', 'paapi-product-search-for-amazon' ); ?></span>
                        </div>
                        <p class="tw-text-sm tw-text-gray-600 tw-m-0"><?php esc_html_e( 'Copy the shortcode and paste it anywhere on your site.', 'paapi-product-search-for-amazon' ); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- CTA Card -->
    <div class="tw-mb-8">
        <h2 class="tw-text-lg tw-font-semibold tw-text-gray-900 tw-m-0 tw-mb-4"><?php esc_html_e( 'Get Product Boxes', 'paapi-product-search-for-amazon' ); ?></h2>
        <div class="tw-bg-white tw-rounded-xl tw-border tw-border-gray-200 tw-shadow-sm tw-p-5">
            <div class="tw-flex tw-items-start tw-gap-3">
                <div class="tw-flex-shrink-0">
                    <span class="tw-flex tw-items-center tw-justify-center tw-w-6 tw-h-6 tw-bg-blue-100 tw-text-blue-600 tw-rounded-full">
                        <svg class="tw-w-4 tw-h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z" />
                        </svg>
                    </span>
                </div>
                <div class="tw-flex-1">
                    <div class="tw-flex tw-items-center tw-gap-2 tw-mb-2">
                        <h3 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0"><?php esc_html_e( 'Premium Add-on', 'paapi-product-search-for-amazon' ); ?></h3>
                        <span class="tw-px-2 tw-py-0.5 tw-text-xs tw-font-medium tw-border tw-border-solid tw-border-blue-300 tw-bg-blue-50 tw-text-blue-700 tw-rounded">$19/year</span>
                    </div>
                    <p class="tw-text-sm tw-text-gray-600 tw-m-0 tw-mb-3"><?php esc_html_e( 'Display individual Amazon products beautifully with one-click save, multiple layouts, image carousels, and premium badges.', 'paapi-product-search-for-amazon' ); ?></p>
                    <ul class="tw-text-sm tw-text-gray-600 tw-m-0 tw-p-0 tw-mb-4" style="list-style: none;">
                        <li class="tw-flex tw-items-center tw-gap-2 tw-mb-1">
                            <svg class="tw-w-4 tw-h-4 tw-text-green-500" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7" />
                            </svg>
                            <?php esc_html_e( 'Card, horizontal & minimal layouts', 'paapi-product-search-for-amazon' ); ?>
                        </li>
                        <li class="tw-flex tw-items-center tw-gap-2 tw-mb-1">
                            <svg class="tw-w-4 tw-h-4 tw-text-green-500" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7" />
                            </svg>
                            <?php esc_html_e( 'Image carousel with navigation', 'paapi-product-search-for-amazon' ); ?>
                        </li>
                        <li class="tw-flex tw-items-center tw-gap-2">
                            <svg class="tw-w-4 tw-h-4 tw-text-green-500" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7" />
                            </svg>
                            <?php esc_html_e( 'Deal badges, discounts & Prime indicators', 'paapi-product-search-for-amazon' ); ?>
                        </li>
                    </ul>
                    <div class="tw-flex tw-items-center tw-gap-3">
                        <a href="<?php echo esc_url( $purchase_url ); ?>" 
                           class="tw-px-4 tw-py-2 tw-bg-brand-primary tw-text-white tw-text-sm tw-font-medium tw-rounded-lg hover:tw-bg-brand-hover tw-transition-colors tw-no-underline focus:tw-outline-none">
                            <?php esc_html_e( 'Get Product Boxes', 'paapi-product-search-for-amazon' ); ?>
                        </a>
                        <span class="tw-text-xs tw-text-gray-500">
                            <?php
                            // translators: %s: upgrade link URL.
                            $requires_text = __( '*Requires <a href="%s" class="tw-text-brand-primary tw-no-underline hover:tw-underline">Paapi Product Search for Amazon - Premium</a>', 'paapi-product-search-for-amazon' );
                            printf(
                                wp_kses(
                                    $requires_text,
                                    array( 'a' => array( 'href' => array(), 'class' => array() ) )
                                ),
                                esc_url( $parent_upgrade_url )
                            );
                            ?>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Shortcode Options -->
    <div class="tw-mb-8">
        <h2 class="tw-text-lg tw-font-semibold tw-text-gray-900 tw-m-0 tw-mb-4"><?php esc_html_e( 'Shortcode Options', 'paapi-product-search-for-amazon' ); ?></h2>
        <div class="tw-bg-white tw-rounded-xl tw-border tw-border-gray-200 tw-shadow-sm tw-p-5">
            <div class="tw-flex tw-items-start tw-gap-3 tw-mb-4">
                <div class="tw-flex-shrink-0">
                    <span class="tw-flex tw-items-center tw-justify-center tw-w-6 tw-h-6 tw-bg-blue-100 tw-text-blue-600 tw-rounded-full">
                        <svg class="tw-w-4 tw-h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M10 20l4-16m4 4l4 4-4 4M6 16l-4-4 4-4" />
                        </svg>
                    </span>
                </div>
                <div class="tw-flex-1">
                    <h3 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0 tw-mb-2"><?php esc_html_e( 'Basic Usage', 'paapi-product-search-for-amazon' ); ?></h3>
                    <code class="tw-block tw-bg-gray-50 tw-border tw-border-gray-200 tw-px-3 tw-py-2 tw-rounded tw-text-sm tw-text-gray-700">[psfa_product_box asin="B09XS7JWHH"]</code>
                </div>
            </div>

            <div class="tw-border-t tw-border-gray-200 tw-pt-4">
                <div class="tw-flex tw-items-center tw-gap-2 tw-mb-3">
                    <span class="tw-flex tw-items-center tw-justify-center tw-w-6 tw-h-6 tw-bg-blue-100 tw-text-blue-600 tw-rounded-full">
                        <svg class="tw-w-4 tw-h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 6V4m0 2a2 2 0 100 4m0-4a2 2 0 110 4m-6 8a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4m6 6v10m6-2a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4" />
                        </svg>
                    </span>
                    <h4 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0"><?php esc_html_e( 'Available Options', 'paapi-product-search-for-amazon' ); ?></h4>
                </div>
                <div class="tw-overflow-x-auto tw-border tw-border-gray-200 tw-rounded-lg">
                    <table class="tw-w-full tw-text-sm">
                        <thead>
                            <tr class="tw-bg-gray-50">
                                <th class="tw-text-left tw-py-2 tw-px-3 tw-font-semibold tw-text-gray-700 tw-border-b tw-border-gray-200"><?php esc_html_e( 'Attribute', 'paapi-product-search-for-amazon' ); ?></th>
                                <th class="tw-text-left tw-py-2 tw-px-3 tw-font-semibold tw-text-gray-700 tw-border-b tw-border-gray-200"><?php esc_html_e( 'Values', 'paapi-product-search-for-amazon' ); ?></th>
                                <th class="tw-text-left tw-py-2 tw-px-3 tw-font-semibold tw-text-gray-700 tw-border-b tw-border-gray-200"><?php esc_html_e( 'Description', 'paapi-product-search-for-amazon' ); ?></th>
                            </tr>
                        </thead>
                        <tbody class="tw-text-gray-600">
                            <tr class="tw-border-b tw-border-gray-200">
                                <td class="tw-py-2 tw-px-3"><code class="tw-bg-gray-100 tw-px-1.5 tw-py-0.5 tw-rounded tw-text-xs">asin</code></td>
                                <td class="tw-py-2 tw-px-3"><?php esc_html_e( 'Amazon ASIN', 'paapi-product-search-for-amazon' ); ?></td>
                                <td class="tw-py-2 tw-px-3"><?php esc_html_e( 'Required. The product ASIN (e.g., B09XS7JWHH)', 'paapi-product-search-for-amazon' ); ?></td>
                            </tr>
                            <tr class="tw-border-b tw-border-gray-200">
                                <td class="tw-py-2 tw-px-3"><code class="tw-bg-gray-100 tw-px-1.5 tw-py-0.5 tw-rounded tw-text-xs">style</code></td>
                                <td class="tw-py-2 tw-px-3"><code class="tw-text-xs">card</code>, <code class="tw-text-xs">horizontal</code>, <code class="tw-text-xs">minimal</code></td>
                                <td class="tw-py-2 tw-px-3"><?php esc_html_e( 'Layout style. Default: card', 'paapi-product-search-for-amazon' ); ?></td>
                            </tr>
                            <tr class="tw-border-b tw-border-gray-200">
                                <td class="tw-py-2 tw-px-3"><code class="tw-bg-gray-100 tw-px-1.5 tw-py-0.5 tw-rounded tw-text-xs">button</code></td>
                                <td class="tw-py-2 tw-px-3"><?php esc_html_e( 'Custom text', 'paapi-product-search-for-amazon' ); ?></td>
                                <td class="tw-py-2 tw-px-3"><?php esc_html_e( 'Button text. Default: "View on Amazon"', 'paapi-product-search-for-amazon' ); ?></td>
                            </tr>
                            <tr>
                                <td class="tw-py-2 tw-px-3"><code class="tw-bg-gray-100 tw-px-1.5 tw-py-0.5 tw-rounded tw-text-xs">nocache</code></td>
                                <td class="tw-py-2 tw-px-3"><code class="tw-text-xs">true</code>, <code class="tw-text-xs">false</code></td>
                                <td class="tw-py-2 tw-px-3"><?php esc_html_e( 'Bypass cache for fresh data. Default: false', 'paapi-product-search-for-amazon' ); ?></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="tw-border-t tw-border-gray-200 tw-pt-4 tw-mt-4">
                <div class="tw-flex tw-items-center tw-gap-2 tw-mb-3">
                    <span class="tw-flex tw-items-center tw-justify-center tw-w-6 tw-h-6 tw-bg-blue-100 tw-text-blue-600 tw-rounded-full">
                        <svg class="tw-w-4 tw-h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2" />
                        </svg>
                    </span>
                    <h4 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0"><?php esc_html_e( 'Examples', 'paapi-product-search-for-amazon' ); ?></h4>
                </div>
                <div class="tw-space-y-2">
                    <div>
                        <span class="tw-text-xs tw-text-gray-500 tw-block tw-mb-1"><?php esc_html_e( 'Horizontal layout:', 'paapi-product-search-for-amazon' ); ?></span>
                        <code class="tw-block tw-bg-gray-50 tw-border tw-border-gray-200 tw-px-3 tw-py-2 tw-rounded tw-text-sm tw-text-gray-700">[psfa_product_box asin="B09XS7JWHH" style="horizontal"]</code>
                    </div>
                    <div>
                        <span class="tw-text-xs tw-text-gray-500 tw-block tw-mb-1"><?php esc_html_e( 'Minimal with custom button:', 'paapi-product-search-for-amazon' ); ?></span>
                        <code class="tw-block tw-bg-gray-50 tw-border tw-border-gray-200 tw-px-3 tw-py-2 tw-rounded tw-text-sm tw-text-gray-700">[psfa_product_box asin="B09XS7JWHH" style="minimal" button="Check Price"]</code>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php
}

/**
 * Render the Comparison Tables promo content
 */
function psfa_render_comparison_tables_promo() {
    $purchase_url = 'https://paapiplugin.com/comparison-tables/';
    $parent_upgrade_url = 'https://paapiplugin.com/pricing/#plans';
    ?>
    <!-- How It Works -->
    <div class="tw-mb-8">
        <h2 class="tw-text-lg tw-font-semibold tw-text-gray-900 tw-m-0 tw-mb-4"><?php esc_html_e( 'How It Works', 'paapi-product-search-for-amazon' ); ?></h2>
        <div class="tw-grid tw-grid-cols-1 md:tw-grid-cols-3 tw-gap-4">
            <div class="tw-bg-white tw-rounded-xl tw-border tw-border-gray-200 tw-shadow-sm tw-p-5">
                <div class="tw-flex tw-items-start tw-gap-3">
                    <div class="tw-flex-shrink-0">
                        <span class="tw-flex tw-items-center tw-justify-center tw-w-6 tw-h-6 tw-bg-blue-100 tw-text-blue-600 tw-rounded-full">
                            <svg class="tw-w-4 tw-h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                            </svg>
                        </span>
                    </div>
                    <div class="tw-flex-1">
                        <div class="tw-flex tw-items-center tw-justify-between tw-gap-2 tw-mb-2">
                            <h3 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0"><?php esc_html_e( 'Search Products', 'paapi-product-search-for-amazon' ); ?></h3>
                            <span class="tw-px-2 tw-py-0.5 tw-text-xs tw-font-medium tw-border tw-border-solid tw-border-gray-300 tw-bg-gray-100 tw-text-gray-700 tw-rounded"><?php esc_html_e( 'Step 1', 'paapi-product-search-for-amazon' ); ?></span>
                        </div>
                        <p class="tw-text-sm tw-text-gray-600 tw-m-0"><?php esc_html_e( 'Visit your search page while logged in as admin.', 'paapi-product-search-for-amazon' ); ?></p>
                    </div>
                </div>
            </div>
            <div class="tw-bg-white tw-rounded-xl tw-border tw-border-gray-200 tw-shadow-sm tw-p-5">
                <div class="tw-flex tw-items-start tw-gap-3">
                    <div class="tw-flex-shrink-0">
                        <span class="tw-flex tw-items-center tw-justify-center tw-w-6 tw-h-6 tw-bg-blue-100 tw-text-blue-600 tw-rounded-full">
                            <svg class="tw-w-4 tw-h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4" />
                            </svg>
                        </span>
                    </div>
                    <div class="tw-flex-1">
                        <div class="tw-flex tw-items-center tw-justify-between tw-gap-2 tw-mb-2">
                            <h3 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0"><?php esc_html_e( 'Click "+ Compare"', 'paapi-product-search-for-amazon' ); ?></h3>
                            <span class="tw-px-2 tw-py-0.5 tw-text-xs tw-font-medium tw-border tw-border-solid tw-border-gray-300 tw-bg-gray-100 tw-text-gray-700 tw-rounded"><?php esc_html_e( 'Step 2', 'paapi-product-search-for-amazon' ); ?></span>
                        </div>
                        <p class="tw-text-sm tw-text-gray-600 tw-m-0"><?php esc_html_e( 'Click "+ Compare" on products you want to compare side-by-side.', 'paapi-product-search-for-amazon' ); ?></p>
                    </div>
                </div>
            </div>
            <div class="tw-bg-white tw-rounded-xl tw-border tw-border-gray-200 tw-shadow-sm tw-p-5">
                <div class="tw-flex tw-items-start tw-gap-3">
                    <div class="tw-flex-shrink-0">
                        <span class="tw-flex tw-items-center tw-justify-center tw-w-6 tw-h-6 tw-bg-blue-100 tw-text-blue-600 tw-rounded-full">
                            <svg class="tw-w-4 tw-h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z" />
                            </svg>
                        </span>
                    </div>
                    <div class="tw-flex-1">
                        <div class="tw-flex tw-items-center tw-justify-between tw-gap-2 tw-mb-2">
                            <h3 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0"><?php esc_html_e( 'Use Shortcode', 'paapi-product-search-for-amazon' ); ?></h3>
                            <span class="tw-px-2 tw-py-0.5 tw-text-xs tw-font-medium tw-border tw-border-solid tw-border-gray-300 tw-bg-gray-100 tw-text-gray-700 tw-rounded"><?php esc_html_e( 'Step 3', 'paapi-product-search-for-amazon' ); ?></span>
                        </div>
                        <p class="tw-text-sm tw-text-gray-600 tw-m-0"><?php esc_html_e( 'Copy the shortcode and paste it anywhere on your site.', 'paapi-product-search-for-amazon' ); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- CTA Card -->
    <div class="tw-mb-8">
        <h2 class="tw-text-lg tw-font-semibold tw-text-gray-900 tw-m-0 tw-mb-4"><?php esc_html_e( 'Get Comparison Tables', 'paapi-product-search-for-amazon' ); ?></h2>
        <div class="tw-bg-white tw-rounded-xl tw-border tw-border-gray-200 tw-shadow-sm tw-p-5">
            <div class="tw-flex tw-items-start tw-gap-3">
                <div class="tw-flex-shrink-0">
                    <span class="tw-flex tw-items-center tw-justify-center tw-w-6 tw-h-6 tw-bg-blue-100 tw-text-blue-600 tw-rounded-full">
                        <svg class="tw-w-4 tw-h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z" />
                        </svg>
                    </span>
                </div>
                <div class="tw-flex-1">
                    <div class="tw-flex tw-items-center tw-gap-2 tw-mb-2">
                        <h3 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0"><?php esc_html_e( 'Premium Add-on', 'paapi-product-search-for-amazon' ); ?></h3>
                        <span class="tw-px-2 tw-py-0.5 tw-text-xs tw-font-medium tw-border tw-border-solid tw-border-blue-300 tw-bg-blue-50 tw-text-blue-700 tw-rounded">$19/year</span>
                    </div>
                    <p class="tw-text-sm tw-text-gray-600 tw-m-0 tw-mb-3"><?php esc_html_e( 'Create beautiful side-by-side comparison tables to help your visitors make informed purchase decisions.', 'paapi-product-search-for-amazon' ); ?></p>
                    <ul class="tw-text-sm tw-text-gray-600 tw-m-0 tw-p-0 tw-mb-4" style="list-style: none;">
                        <li class="tw-flex tw-items-center tw-gap-2 tw-mb-1">
                            <svg class="tw-w-4 tw-h-4 tw-text-green-500" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7" />
                            </svg>
                            <?php esc_html_e( 'Unlimited comparison tables', 'paapi-product-search-for-amazon' ); ?>
                        </li>
                        <li class="tw-flex tw-items-center tw-gap-2 tw-mb-1">
                            <svg class="tw-w-4 tw-h-4 tw-text-green-500" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7" />
                            </svg>
                            <?php esc_html_e( 'Drag-and-drop product ordering', 'paapi-product-search-for-amazon' ); ?>
                        </li>
                        <li class="tw-flex tw-items-center tw-gap-2 tw-mb-1">
                            <svg class="tw-w-4 tw-h-4 tw-text-green-500" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7" />
                            </svg>
                            <?php esc_html_e( 'Winner Highlighting (Best Value, Editor\'s Choice, Best Rated, etc.)', 'paapi-product-search-for-amazon' ); ?>
                        </li>
                        <li class="tw-flex tw-items-center tw-gap-2">
                            <svg class="tw-w-4 tw-h-4 tw-text-green-500" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7" />
                            </svg>
                            <?php esc_html_e( 'Responsive mobile design (stack or scroll)', 'paapi-product-search-for-amazon' ); ?>
                        </li>
                    </ul>
                    <div class="tw-flex tw-items-center tw-gap-3">
                        <a href="<?php echo esc_url( $purchase_url ); ?>" 
                           class="tw-px-4 tw-py-2 tw-bg-brand-primary tw-text-white tw-text-sm tw-font-medium tw-rounded-lg hover:tw-bg-brand-hover tw-transition-colors tw-no-underline focus:tw-outline-none">
                            <?php esc_html_e( 'Get Comparison Tables', 'paapi-product-search-for-amazon' ); ?>
                        </a>
                        <span class="tw-text-xs tw-text-gray-500">
                            <?php
                            /* translators: %s: URL to upgrade page */
                            $requires_text = __( '*Requires <a href="%s" class="tw-text-brand-primary tw-no-underline hover:tw-underline">Paapi Product Search for Amazon - Premium</a>', 'paapi-product-search-for-amazon' );
                            printf(
                                wp_kses(
                                    $requires_text,
                                    array( 'a' => array( 'href' => array(), 'class' => array() ) )
                                ),
                                esc_url( $parent_upgrade_url )
                            );
                            ?>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Shortcode Options -->
    <div class="tw-mb-8">
        <h2 class="tw-text-lg tw-font-semibold tw-text-gray-900 tw-m-0 tw-mb-4"><?php esc_html_e( 'Shortcode Options', 'paapi-product-search-for-amazon' ); ?></h2>
        <div class="tw-bg-white tw-rounded-xl tw-border tw-border-gray-200 tw-shadow-sm tw-p-5">
            <div class="tw-flex tw-items-start tw-gap-3 tw-mb-4">
                <div class="tw-flex-shrink-0">
                    <span class="tw-flex tw-items-center tw-justify-center tw-w-6 tw-h-6 tw-bg-blue-100 tw-text-blue-600 tw-rounded-full">
                        <svg class="tw-w-4 tw-h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M10 20l4-16m4 4l4 4-4 4M6 16l-4-4 4-4" />
                        </svg>
                    </span>
                </div>
                <div class="tw-flex-1">
                    <h3 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0 tw-mb-2"><?php esc_html_e( 'Basic Usage', 'paapi-product-search-for-amazon' ); ?></h3>
                    <code class="tw-block tw-bg-gray-50 tw-border tw-border-gray-200 tw-px-3 tw-py-2 tw-rounded tw-text-sm tw-text-gray-700">[psfa_comparison id="5"]</code>
                </div>
            </div>

            <div class="tw-border-t tw-border-gray-200 tw-pt-4">
                <div class="tw-flex tw-items-center tw-gap-2 tw-mb-3">
                    <span class="tw-flex tw-items-center tw-justify-center tw-w-6 tw-h-6 tw-bg-blue-100 tw-text-blue-600 tw-rounded-full">
                        <svg class="tw-w-4 tw-h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 6V4m0 2a2 2 0 100 4m0-4a2 2 0 110 4m-6 8a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4m6 6v10m6-2a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4" />
                        </svg>
                    </span>
                    <h4 class="tw-text-sm tw-font-semibold tw-text-gray-900 tw-m-0"><?php esc_html_e( 'Available Options', 'paapi-product-search-for-amazon' ); ?></h4>
                </div>
                <div class="tw-overflow-x-auto tw-border tw-border-gray-200 tw-rounded-lg">
                    <table class="tw-w-full tw-text-sm">
                        <thead>
                            <tr class="tw-bg-gray-50">
                                <th class="tw-text-left tw-py-2 tw-px-3 tw-font-semibold tw-text-gray-700 tw-border-b tw-border-gray-200"><?php esc_html_e( 'Attribute', 'paapi-product-search-for-amazon' ); ?></th>
                                <th class="tw-text-left tw-py-2 tw-px-3 tw-font-semibold tw-text-gray-700 tw-border-b tw-border-gray-200"><?php esc_html_e( 'Values', 'paapi-product-search-for-amazon' ); ?></th>
                                <th class="tw-text-left tw-py-2 tw-px-3 tw-font-semibold tw-text-gray-700 tw-border-b tw-border-gray-200"><?php esc_html_e( 'Description', 'paapi-product-search-for-amazon' ); ?></th>
                            </tr>
                        </thead>
                        <tbody class="tw-text-gray-600">
                            <tr class="tw-border-b tw-border-gray-200">
                                <td class="tw-py-2 tw-px-3"><code class="tw-bg-gray-100 tw-px-1.5 tw-py-0.5 tw-rounded tw-text-xs">id</code></td>
                                <td class="tw-py-2 tw-px-3"><?php esc_html_e( 'Table ID', 'paapi-product-search-for-amazon' ); ?></td>
                                <td class="tw-py-2 tw-px-3"><?php esc_html_e( 'Required. The comparison table ID.', 'paapi-product-search-for-amazon' ); ?></td>
                            </tr>
                            <tr class="tw-border-b tw-border-gray-200">
                                <td class="tw-py-2 tw-px-3"><code class="tw-bg-gray-100 tw-px-1.5 tw-py-0.5 tw-rounded tw-text-xs">columns</code></td>
                                <td class="tw-py-2 tw-px-3"><code class="tw-text-xs">image,title,price,rating,button</code></td>
                                <td class="tw-py-2 tw-px-3"><?php esc_html_e( 'Comma-separated list of columns to display.', 'paapi-product-search-for-amazon' ); ?></td>
                            </tr>
                            <tr class="tw-border-b tw-border-gray-200">
                                <td class="tw-py-2 tw-px-3"><code class="tw-bg-gray-100 tw-px-1.5 tw-py-0.5 tw-rounded tw-text-xs">size</code></td>
                                <td class="tw-py-2 tw-px-3"><code class="tw-text-xs">small</code>, <code class="tw-text-xs">medium</code>, <code class="tw-text-xs">large</code></td>
                                <td class="tw-py-2 tw-px-3"><?php esc_html_e( 'Table size variant. Default: medium', 'paapi-product-search-for-amazon' ); ?></td>
                            </tr>
                            <tr class="tw-border-b tw-border-gray-200">
                                <td class="tw-py-2 tw-px-3"><code class="tw-bg-gray-100 tw-px-1.5 tw-py-0.5 tw-rounded tw-text-xs">layout</code></td>
                                <td class="tw-py-2 tw-px-3"><code class="tw-text-xs">horizontal</code>, <code class="tw-text-xs">vertical</code></td>
                                <td class="tw-py-2 tw-px-3"><?php esc_html_e( 'Table layout. Default: horizontal', 'paapi-product-search-for-amazon' ); ?></td>
                            </tr>
                            <tr class="tw-border-b tw-border-gray-200">
                                <td class="tw-py-2 tw-px-3"><code class="tw-bg-gray-100 tw-px-1.5 tw-py-0.5 tw-rounded tw-text-xs">winner</code></td>
                                <td class="tw-py-2 tw-px-3"><code class="tw-text-xs">true</code>, <code class="tw-text-xs">false</code></td>
                                <td class="tw-py-2 tw-px-3"><?php esc_html_e( 'Highlight best value product. Default: true', 'paapi-product-search-for-amazon' ); ?></td>
                            </tr>
                            <tr class="tw-border-b tw-border-gray-200">
                                <td class="tw-py-2 tw-px-3"><code class="tw-bg-gray-100 tw-px-1.5 tw-py-0.5 tw-rounded tw-text-xs">button_text</code></td>
                                <td class="tw-py-2 tw-px-3"><?php esc_html_e( 'Custom text', 'paapi-product-search-for-amazon' ); ?></td>
                                <td class="tw-py-2 tw-px-3"><?php esc_html_e( 'Custom button text. Default: View on Amazon', 'paapi-product-search-for-amazon' ); ?></td>
                            </tr>
                            <tr>
                                <td class="tw-py-2 tw-px-3"><code class="tw-bg-gray-100 tw-px-1.5 tw-py-0.5 tw-rounded tw-text-xs">responsive</code></td>
                                <td class="tw-py-2 tw-px-3"><code class="tw-text-xs">stack</code>, <code class="tw-text-xs">scroll</code></td>
                                <td class="tw-py-2 tw-px-3"><?php esc_html_e( 'Mobile layout. Default: stack for horizontal, scroll for vertical', 'paapi-product-search-for-amazon' ); ?></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php
}
