<?php
/**
 * Admin Layout tab renderer.
 *
 * Extracted from the main plugin class to keep responsibilities focused and
 * the main file smaller.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Render the Layout tab contents.
 */
function psfa_render_layout_tab() {
    require_once PSFA_PLUGIN_DIR . 'core/search/view-helpers.php';
    require_once PSFA_PLUGIN_DIR . 'core/shared/theme-manager.php';
    
    // Preserve credentials, theme, and customization settings when saving from layout tab
    $access_key = get_option('psfa_access_key_id', '');
    $secret_key = get_option('psfa_secret_access_key', '');
    $associate_tag = get_option('psfa_associate_tag', '');
    $selected_theme = psfa_get_selected_theme();
    $button_text = get_option('psfa_button_text', 'Buy on Amazon');
    $button_border_radius = get_option('psfa_button_border_radius', '');
    $button_font_size = get_option('psfa_button_font_size', '');
    $button_font_weight = get_option('psfa_button_font_weight', '');
    $card_layout = get_option('psfa_card_layout', 'default');
    $title_font = get_option('psfa_title_font', '');
    $description_font = get_option('psfa_description_font', '');
    $price_font = get_option('psfa_price_font', '');
    $theme_colors = get_option('psfa_theme_colors', array());
    $hide_banner = get_option('psfa_hide_category_banner', false);
    ?>
    <div class="psfa-tab-section">
        <form action="options.php" method="post">
            <?php 
            settings_fields( 'psfa_settings' );
            ?>
            <input type="hidden" name="psfa_access_key_id" value="<?php echo esc_attr($access_key); ?>">
            <input type="hidden" name="psfa_secret_access_key" value="<?php echo esc_attr($secret_key); ?>">
            <input type="hidden" name="psfa_associate_tag" value="<?php echo esc_attr($associate_tag); ?>">
            <input type="hidden" name="psfa_selected_theme" value="<?php echo esc_attr($selected_theme); ?>">
            <input type="hidden" name="psfa_button_text" value="<?php echo esc_attr($button_text); ?>">
            <input type="hidden" name="psfa_button_border_radius" value="<?php echo esc_attr($button_border_radius); ?>">
            <input type="hidden" name="psfa_button_font_size" value="<?php echo esc_attr($button_font_size); ?>">
            <input type="hidden" name="psfa_button_font_weight" value="<?php echo esc_attr($button_font_weight); ?>">
            <input type="hidden" name="psfa_card_layout" value="<?php echo esc_attr($card_layout); ?>">
            <input type="hidden" name="psfa_title_font" value="<?php echo esc_attr($title_font); ?>">
            <input type="hidden" name="psfa_description_font" value="<?php echo esc_attr($description_font); ?>">
            <input type="hidden" name="psfa_price_font" value="<?php echo esc_attr($price_font); ?>">
            <?php if (!empty($theme_colors)): ?>
                <?php foreach ($theme_colors as $theme_slug => $colors): ?>
                    <?php foreach ($colors as $color_key => $color_value): ?>
                        <input type="hidden" name="psfa_theme_colors[<?php echo esc_attr($theme_slug); ?>][<?php echo esc_attr($color_key); ?>]" value="<?php echo esc_attr($color_value); ?>">
                    <?php endforeach; ?>
                <?php endforeach; ?>
            <?php endif; ?>
            <?php psfa_render_display_mode_selection(); ?>
            
            <div style="margin-top: 30px; padding: 20px; background: #fff; border: 1px solid #ddd; border-radius: 4px;">
                <div class="psfa-layout-header" style="margin-bottom: 15px;">
                    <span class="psfa-layout-icon dashicons dashicons-visibility"></span>
                    <h3 style="margin: 0; display: inline-block; vertical-align: middle;">Display Options</h3>
                    <span class="psfa-badge-free-small" style="margin-left: 10px;">Free</span>
                </div>
                <table class="form-table">
                    <tr>
                        <th scope="row">Hide Category Banner</th>
                        <td>
                            <label>
                                <input type="checkbox" name="psfa_hide_category_banner" value="1" id="psfa_hide_category_banner" <?php checked(get_option('psfa_hide_category_banner', false), true); ?>>
                                Hide the "Top Products in [Category]" banner header
                            </label>
                            <p class="description">When enabled, the category header banner will be hidden on category pages.</p>
                        </td>
                    </tr>
                </table>
            </div>
            
            <?php
            // Get current filter visibility settings (default all visible)
            $filter_visibility = get_option('psfa_filter_visibility', array(
                'brand'        => true,
                'price'        => true,
                'sort'         => true,
                'condition'    => true,
                'merchant'     => true,
                'availability' => true,
                'prime'        => true,
                'deals'        => true,
            ));
            ?>
            <div style="margin-top: 30px; padding: 20px; background: #fff; border: 1px solid #ddd; border-radius: 4px;">
                <div class="psfa-layout-header" style="margin-bottom: 15px;">
                    <span class="psfa-layout-icon dashicons dashicons-filter"></span>
                    <h3 style="margin: 0; display: inline-block; vertical-align: middle;">Filter Visibility</h3>
                    <span class="psfa-badge-free-small" style="margin-left: 10px;">Free</span>
                </div>
                <p class="description" style="margin-bottom: 15px;">Choose which filters to display in the search interface. Unchecked filters will be hidden from visitors.</p>
                <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(200px, 1fr)); gap: 10px;">
                    <label style="display: flex; align-items: center; padding: 8px 12px; background: #f9f9f9; border-radius: 4px; cursor: pointer;">
                        <input type="checkbox" name="psfa_filter_visibility[brand]" value="1" <?php checked(!empty($filter_visibility['brand'])); ?> style="margin-right: 8px;">
                        <span>Brand</span>
                        <span class="psfa-badge-free-small" style="margin-left: 6px; font-size: 10px;">Free</span>
                    </label>
                    <label style="display: flex; align-items: center; padding: 8px 12px; background: #f9f9f9; border-radius: 4px; cursor: pointer;">
                        <input type="checkbox" name="psfa_filter_visibility[price]" value="1" <?php checked(!empty($filter_visibility['price'])); ?> style="margin-right: 8px;">
                        <span>Price Range</span>
                        <span class="psfa-badge-free-small" style="margin-left: 6px; font-size: 10px;">Free</span>
                    </label>
                    <label style="display: flex; align-items: center; padding: 8px 12px; background: #f9f9f9; border-radius: 4px; cursor: pointer;">
                        <input type="checkbox" name="psfa_filter_visibility[sort]" value="1" <?php checked(!empty($filter_visibility['sort'])); ?> style="margin-right: 8px;">
                        <span>Sort By</span>
                        <span class="psfa-badge-free-small" style="margin-left: 6px; font-size: 10px;">Free</span>
                    </label>
                    <label style="display: flex; align-items: center; padding: 8px 12px; background: #f9f9f9; border-radius: 4px; cursor: pointer;">
                        <input type="checkbox" name="psfa_filter_visibility[condition]" value="1" <?php checked(!empty($filter_visibility['condition'])); ?> style="margin-right: 8px;">
                        <span>Condition</span>
                        <span class="psfa-badge-free-small" style="margin-left: 6px; font-size: 10px;">Free</span>
                    </label>
                    <label style="display: flex; align-items: center; padding: 8px 12px; background: #f9f9f9; border-radius: 4px; cursor: pointer;">
                        <input type="checkbox" name="psfa_filter_visibility[merchant]" value="1" <?php checked(!empty($filter_visibility['merchant'])); ?> style="margin-right: 8px;">
                        <span>Merchant</span>
                        <span class="psfa-badge-free-small" style="margin-left: 6px; font-size: 10px;">Free</span>
                    </label>
                    <label style="display: flex; align-items: center; padding: 8px 12px; background: #f9f9f9; border-radius: 4px; cursor: pointer;">
                        <input type="checkbox" name="psfa_filter_visibility[availability]" value="1" <?php checked(!empty($filter_visibility['availability'])); ?> style="margin-right: 8px;">
                        <span>Availability</span>
                        <span class="psfa-badge-free-small" style="margin-left: 6px; font-size: 10px;">Free</span>
                    </label>
                    <?php  ?>
                </div>
            </div>
            
            <div style="margin-top: 20px; padding-top: 20px; border-top: 1px solid #ddd;">
                <?php 
                if ( function_exists( 'submit_button' ) ) {
                    submit_button( 'Save Settings', 'primary', 'submit', false );
                } else {
                    echo '<input type="submit" name="submit" class="button button-primary" value="Save Settings">';
                }
                ?>
                <a href="<?php echo esc_url( wp_nonce_url( add_query_arg( array(
                    'page'                    => 'paapi-product-search-for-amazon',
                    'tab'                     => 'layout',
                    'psfa_reset_customization' => '1',
                ), admin_url( 'admin.php' ) ), 'psfa_reset_customization' ) ); ?>" class="button button-secondary" style="margin-left: 10px;" onclick="return confirm('Are you sure you want to reset all layout settings to their defaults?');">Reset to Defaults</a>
            </div>
        </form>
    </div>
    <?php
}

/**
 * Render display mode selection (grid/list).
 */
function psfa_render_display_mode_selection() {
    require_once PSFA_PLUGIN_DIR . 'core/search/view-helpers.php';
    
    // Default values for free build
    $is_premium = false;
    $upgrade_url = 'https://paapiplugin.com/pricing/#plans';
    
    
    
    $current_mode = get_option('psfa_display_mode', 'grid');
    
    // Force grid mode for free users if list was previously selected
    if ($current_mode === 'list' && !$is_premium) {
        $current_mode = 'grid';
        update_option('psfa_display_mode', 'grid');
    }
    
    echo '<div class="psfa-layout-selection">';
    echo '<h2 style="margin-top: 0;">Display Layout</h2>';
    echo '<p class="description">Choose how products are displayed on your site.</p>';
    echo '<div class="psfa-layout-options">';
    
    // Grid Layout Option
    $grid_selected = $current_mode === 'grid';
    $grid_disabled = false;
    echo '<div class="psfa-layout-card ' . ($grid_selected ? 'psfa-layout-selected' : '') . '">';
    echo '<label class="psfa-layout-label">';
    echo '<div class="psfa-layout-content">';
    echo '<div class="psfa-layout-header">';
    echo '<span class="psfa-layout-icon dashicons dashicons-grid-view"></span>';
    echo '<h3>Grid Layout</h3>';
    echo '<span class="psfa-badge-free-small">Free</span>';
    echo '</div>';
    echo '<p class="psfa-layout-description">Products displayed in a responsive grid format, perfect for browsing multiple items at once.</p>';
    echo '<div><input type="radio" name="psfa_display_mode" value="grid" style="position: absolute; bottom: -10px; left: 0px;"' . checked($grid_selected, true, false) . ' class="psfa-layout-radio"></div>';
    echo '</div>';
    echo '</label>';
    echo '</div>';
    
    // List Layout Option (Premium only)
    $list_selected = $current_mode === 'list' && $is_premium;
    
    if ($is_premium) {
        // Premium user - show selectable radio button
        $list_card_classes = 'psfa-layout-card' . ($list_selected ? ' psfa-layout-selected' : '');
        echo '<div class="' . esc_attr($list_card_classes) . '">';
        echo '<label class="psfa-layout-label">';
        echo '<div class="psfa-layout-content">';
        echo '<div class="psfa-layout-header">';
        echo '<span class="psfa-layout-icon dashicons dashicons-list-view"></span>';
        echo '<h3>List Layout</h3>';
        echo '<span class="psfa-badge-premium-small">Premium</span>';
        echo '</div>';
        echo '<p class="psfa-layout-description">Products displayed in a vertical list format, ideal for detailed product information and comparisons.</p>';
        echo '<div><input type="radio" name="psfa_display_mode" value="list" style="position: absolute; bottom: -10px; left: 0px;"' . checked($current_mode === 'list', true, false) . ' class="psfa-layout-radio"></div>';
        echo '</div>';
        echo '</label>';
        echo '</div>';
    } else {
        // Free user - show as preview card (no disabled controls)
        echo '<div class="psfa-layout-card">';
        echo '<div class="psfa-layout-content">';
        echo '<div class="psfa-layout-header">';
        echo '<span class="psfa-layout-icon dashicons dashicons-list-view"></span>';
        echo '<h3>List Layout</h3>';
        echo '<span class="psfa-badge-premium-small">Premium</span>';
        echo '</div>';
        echo '<p class="psfa-layout-description">Products displayed in a vertical list format, ideal for detailed product information and comparisons.</p>';
        echo '<div style="margin-top: 12px; padding: 8px 12px; background: #fff3cd; border-left: 3px solid #ffc107; border-radius: 3px;">';
        echo '<span class="description" style="font-size: 12px; color: #856404;">';
        echo '<a href="' . esc_url($upgrade_url) . '" target="_blank" style="color: #2271b1; text-decoration: none; font-weight: 600;">Upgrade to Premium</a> to unlock this layout.';
        echo '</span>';
        echo '</div>';
        echo '</div>';
        echo '</div>';
    }
    
    echo '</div>';
    echo '</div>';
    // Note: Layout card JS is enqueued via wp_add_inline_script in main plugin file
}

