<?php
/**
 * Admin Features tab renderer.
 *
 * Extracted from the main plugin class to keep responsibilities focused and
 * the main file smaller.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Render the Features tab contents.
 */
function psfa_render_features_tab() {
    require_once PSFA_PLUGIN_DIR . 'core/admin/premium-features.php';
    
    $features = psfa_get_all_premium_features();
    
    // Free features
    $free_features = array(
        array(
            'key' => 'shortcode_builder',
            'name' => 'Shortcode Builder',
            'description' => 'Visual shortcode builder to easily create and customize your product search shortcodes with all available options.',
            'plan' => 'free',
            'enabled' => true,
            'icon' => 'dashicons-shortcode',
        ),
        array(
            'key' => 'search_autocomplete',
            'name' => 'Search Autocomplete',
            'description' => 'Real-time search suggestions as users type, powered by Amazon\'s search data.',
            'plan' => 'free',
            'enabled' => true,
            'icon' => 'dashicons-search',
        ),
        array(
            'key' => 'filters',
            'name' => 'Product Filters',
            'description' => 'Filter products by brand, price range, condition, and merchant.',
            'plan' => 'free',
            'enabled' => true,
            'icon' => 'dashicons-filter',
        ),
        array(
            'key' => 'grid_display',
            'name' => 'Grid Display Mode',
            'description' => 'Display products in a responsive grid layout that works on all devices.',
            'plan' => 'free',
            'enabled' => true,
            'icon' => 'dashicons-grid-view',
        ),
        array(
            'key' => 'infinite_scroll',
            'name' => 'Infinite Scroll',
            'description' => 'Automatically load more products as users scroll (up to 5 pages in free version).',
            'plan' => 'free',
            'enabled' => true,
            'icon' => 'dashicons-arrow-down-alt',
        ),
    );
    ?>
    <div class="psfa-tab-section">
        <h2 style="margin-top: 0;">Free Features</h2>
        <p class="description">These features are available in the free version.</p>
        <div class="psfa-features-grid" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px; margin-top: 20px;">
            <?php foreach ($free_features as $feature) : ?>
                <?php echo wp_kses_post( psfa_render_feature_card($feature) ); ?>
            <?php endforeach; ?>
        </div>
        
        <h2 style="margin-top: 40px;">Premium Features</h2>
        <p class="description">Upgrade to Premium to unlock these features.</p>
        <div class="psfa-features-grid" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px; margin-top: 20px;">
            <?php foreach ($features as $feature) : ?>
                <?php echo wp_kses_post( psfa_render_feature_card($feature) ); ?>
            <?php endforeach; ?>
        </div>
    </div>
    <?php
}

