<?php
/**
 * Admin Customization tab renderer.
 *
 * Extracted from the main plugin class to keep responsibilities focused and
 * the main file smaller.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Render the Customization tab contents.
 */
function psfa_render_customization_tab() {
    require_once PSFA_PLUGIN_DIR . 'core/search/view-helpers.php';
    require_once PSFA_PLUGIN_DIR . 'core/shared/theme-manager.php';
    require_once PSFA_PLUGIN_DIR . 'core/shared/customization-helpers.php';

    $is_premium     = psfa_is_premium();
    $upgrade_url    = 'https://paapiplugin.com/pricing/#plans';
    $themes         = psfa_get_all_themes();
    $selected_theme = psfa_get_selected_theme();

    // Get current settings
    $button_text          = get_option( 'psfa_button_text', 'Buy on Amazon' );
    $button_border_radius = get_option( 'psfa_button_border_radius', '' );
    $button_font_size     = get_option( 'psfa_button_font_size', '' );
    $button_font_weight   = get_option( 'psfa_button_font_weight', '' );
    $card_layout          = get_option( 'psfa_card_layout', 'default' );
    $title_font           = get_option( 'psfa_title_font', '' );
    $description_font     = get_option( 'psfa_description_font', '' );
    $price_font           = get_option( 'psfa_price_font', '' );
    $theme_colors         = get_option( 'psfa_theme_colors', array() );

    // Google Fonts list (popular choices)
    $google_fonts = array(
        ''                 => 'Default (Theme Font)',
        'Roboto'           => 'Roboto',
        'Open Sans'        => 'Open Sans',
        'Lato'             => 'Lato',
        'Montserrat'       => 'Montserrat',
        'Poppins'          => 'Poppins',
        'Raleway'          => 'Raleway',
        'Source Sans Pro'  => 'Source Sans Pro',
        'Oswald'           => 'Oswald',
        'Playfair Display' => 'Playfair Display',
        'Merriweather'     => 'Merriweather',
    );

    ?>
    <div class="psfa-customization-wrapper" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(320px, 1fr)); gap: 20px;">
        
        <!-- Button Customization -->
        <div class="psfa-customization-section">
            <div class="psfa-layout-header">
                <span class="psfa-layout-icon dashicons dashicons-edit"></span>
                <h3>Button Customization</h3>
                <span class="psfa-badge-premium-small">Premium</span>
            </div>
            <p class="description">Customize the "Buy on Amazon" button appearance and text.</p>
            <?php if ( $is_premium ) : ?>
            <table class="form-table">
                <tr>
                    <th scope="row">Button Text <?php echo wp_kses_post( psfa_info_tip('The text displayed on the "Buy on Amazon" button. Customize to match your site\'s tone.') ); ?></th>
                    <td>
                        <input type="text" name="psfa_button_text" value="<?php echo esc_attr( $button_text ); ?>" class="regular-text" placeholder="Buy on Amazon">
                    </td>
                </tr>
                <tr>
                    <th scope="row">Button Border Radius <?php echo wp_kses_post( psfa_info_tip('Controls how rounded the button corners are. Use 0 for square, 4px for slightly rounded, 50% for pill shape.') ); ?></th>
                    <td>
                        <input type="text" name="psfa_button_border_radius" value="<?php echo esc_attr( $button_border_radius ); ?>" class="small-text" placeholder="e.g., 4px">
                    </td>
                </tr>
                <tr>
                    <th scope="row">Button Font Size <?php echo wp_kses_post( psfa_info_tip('Size of the button text. Use CSS units like 14px, 1rem, etc.') ); ?></th>
                    <td>
                        <input type="text" name="psfa_button_font_size" value="<?php echo esc_attr( $button_font_size ); ?>" class="small-text" placeholder="e.g., 14px">
                    </td>
                </tr>
                <tr>
                    <th scope="row">Button Font Weight <?php echo wp_kses_post( psfa_info_tip('Controls how bold the button text appears. Higher numbers = bolder text.') ); ?></th>
                    <td>
                        <select name="psfa_button_font_weight">
                            <option value="">Default</option>
                            <option value="300" <?php selected( $button_font_weight, '300' ); ?>>Light (300)</option>
                            <option value="400" <?php selected( $button_font_weight, '400' ); ?>>Normal (400)</option>
                            <option value="500" <?php selected( $button_font_weight, '500' ); ?>>Medium (500)</option>
                            <option value="600" <?php selected( $button_font_weight, '600' ); ?>>Semi-Bold (600)</option>
                            <option value="700" <?php selected( $button_font_weight, '700' ); ?>>Bold (700)</option>
                        </select>
                    </td>
                </tr>
            </table>
            <?php else : ?>
            <ul style="margin: 15px 0; padding-left: 20px; color: #646970;">
                <li>Custom button text</li>
                <li>Border radius control</li>
                <li>Font size adjustment</li>
                <li>Font weight options</li>
            </ul>
            <div style="margin-top: 15px; padding: 8px 12px; background: #fff3cd; border-left: 3px solid #ffc107; border-radius: 3px;">
                <span class="description" style="font-size: 12px; color: #856404;">
                    <a href="<?php echo esc_url( $upgrade_url ); ?>" target="_blank" style="color: #2271b1; text-decoration: none; font-weight: 600;">Upgrade to Premium</a> to unlock this feature.
                </span>
            </div>
            <?php endif; ?>
        </div>
        
        <!-- Card Layouts -->
        <div class="psfa-customization-section">
            <div class="psfa-layout-header">
                <span class="psfa-layout-icon dashicons dashicons-layout"></span>
                <h3>Product Card Layout</h3>
                <span class="psfa-badge-premium-small">Premium</span>
            </div>
            <p class="description">Choose how product cards are displayed.</p>
            <?php if ( $is_premium ) : ?>
            <table class="form-table">
                <tr>
                    <th scope="row">Card Layout <?php echo wp_kses_post( psfa_info_tip('Default: balanced layout. Compact: smaller cards, more per row. Detailed: shows more product info. Image Focused: larger product images.') ); ?></th>
                    <td>
                        <select name="psfa_card_layout">
                            <option value="default" <?php selected( $card_layout, 'default' ); ?>>Default</option>
                            <option value="compact" <?php selected( $card_layout, 'compact' ); ?>>Compact</option>
                            <option value="detailed" <?php selected( $card_layout, 'detailed' ); ?>>Detailed</option>
                            <option value="image_focused" <?php selected( $card_layout, 'image_focused' ); ?>>Image Focused</option>
                        </select>
                    </td>
                </tr>
            </table>
            <?php else : ?>
            <ul style="margin: 15px 0; padding-left: 20px; color: #646970;">
                <li>Default - balanced layout</li>
                <li>Compact - smaller cards, more per row</li>
                <li>Detailed - shows more product info</li>
                <li>Image Focused - larger product images</li>
            </ul>
            <div style="margin-top: 15px; padding: 8px 12px; background: #fff3cd; border-left: 3px solid #ffc107; border-radius: 3px;">
                <span class="description" style="font-size: 12px; color: #856404;">
                    <a href="<?php echo esc_url( $upgrade_url ); ?>" target="_blank" style="color: #2271b1; text-decoration: none; font-weight: 600;">Upgrade to Premium</a> to unlock this feature.
                </span>
            </div>
            <?php endif; ?>
        </div>
        
        <!-- Font Customization -->
        <div class="psfa-customization-section">
            <div class="psfa-layout-header">
                <span class="psfa-layout-icon dashicons dashicons-editor-textcolor"></span>
                <h3>Font Customization</h3>
                <span class="psfa-badge-premium-small">Premium</span>
            </div>
            <p class="description">Choose custom fonts for product display elements.</p>
            <?php if ( $is_premium ) : ?>
            <table class="form-table">
                <tr>
                    <th scope="row">Title Font <?php echo wp_kses_post( psfa_info_tip('Font used for product titles. Google Fonts are loaded automatically.') ); ?></th>
                    <td>
                        <select name="psfa_title_font">
                            <?php foreach ( $google_fonts as $font_value => $font_label ) : ?>
                                <option value="<?php echo esc_attr( $font_value ); ?>" <?php selected( $title_font, $font_value ); ?>><?php echo esc_html( $font_label ); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </td>
                </tr>
                <tr>
                    <th scope="row">Description Font <?php echo wp_kses_post( psfa_info_tip('Font used for product descriptions and features list.') ); ?></th>
                    <td>
                        <select name="psfa_description_font">
                            <?php foreach ( $google_fonts as $font_value => $font_label ) : ?>
                                <option value="<?php echo esc_attr( $font_value ); ?>" <?php selected( $description_font, $font_value ); ?>><?php echo esc_html( $font_label ); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </td>
                </tr>
                <tr>
                    <th scope="row">Price Font <?php echo wp_kses_post( psfa_info_tip('Font used for product prices. Consider using a font that displays numbers clearly.') ); ?></th>
                    <td>
                        <select name="psfa_price_font">
                            <?php foreach ( $google_fonts as $font_value => $font_label ) : ?>
                                <option value="<?php echo esc_attr( $font_value ); ?>" <?php selected( $price_font, $font_value ); ?>><?php echo esc_html( $font_label ); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </td>
                </tr>
            </table>
            <?php else : ?>
            <ul style="margin: 15px 0; padding-left: 20px; color: #646970;">
                <li>Custom title fonts from Google Fonts</li>
                <li>Custom description fonts</li>
                <li>Custom price fonts</li>
                <li>10+ popular font choices</li>
            </ul>
            <div style="margin-top: 15px; padding: 8px 12px; background: #fff3cd; border-left: 3px solid #ffc107; border-radius: 3px;">
                <span class="description" style="font-size: 12px; color: #856404;">
                    <a href="<?php echo esc_url( $upgrade_url ); ?>" target="_blank" style="color: #2271b1; text-decoration: none; font-weight: 600;">Upgrade to Premium</a> to unlock this feature.
                </span>
            </div>
            <?php endif; ?>
        </div>
        
        <!-- Theme Colors -->
        <div class="psfa-customization-section">
            <div class="psfa-layout-header">
                <span class="psfa-layout-icon dashicons dashicons-admin-customizer"></span>
                <h3>Custom Color Schemes</h3>
                <span class="psfa-badge-premium-small">Premium</span>
            </div>
            <p class="description">Customize colors for the currently selected theme: <strong><?php echo esc_html( $themes[ $selected_theme ]['name'] ?? $selected_theme ); ?></strong></p>
            <?php if ( $is_premium ) : ?>
            <?php
            // Only show colors for the selected theme
            if ( isset( $themes[ $selected_theme ] ) ) {
                $theme      = $themes[ $selected_theme ];
                $theme_slug = $selected_theme;

                $current_colors = isset( $theme_colors[ $theme_slug ] ) ? $theme_colors[ $theme_slug ] : array();
                $default_colors = psfa_get_theme_default_colors( $theme_slug );

                // Use current color if set, otherwise leave empty (default will be shown visually by JS)
                $primary_color    = isset( $current_colors['primary_color'] ) && '' !== $current_colors['primary_color'] ? $current_colors['primary_color'] : '';
                $secondary_color  = isset( $current_colors['secondary_color'] ) && '' !== $current_colors['secondary_color'] ? $current_colors['secondary_color'] : '';
                $button_bg        = isset( $current_colors['button_bg'] ) && '' !== $current_colors['button_bg'] ? $current_colors['button_bg'] : '';
                $button_text_color = isset( $current_colors['button_text'] ) && '' !== $current_colors['button_text'] ? $current_colors['button_text'] : '';
                $text_color       = isset( $current_colors['text_color'] ) && '' !== $current_colors['text_color'] ? $current_colors['text_color'] : '';
                $price_color      = isset( $current_colors['price_color'] ) && '' !== $current_colors['price_color'] ? $current_colors['price_color'] : '';
                ?>
                <table class="form-table" style="margin-top: 15px;">
                    <tr>
                        <th scope="row" style="padding: 8px 0; font-weight: 500;">Primary Color <?php echo wp_kses_post( psfa_info_tip('Main accent color used for borders, highlights, and interactive elements.') ); ?></th>
                        <td style="padding: 8px 0;">
                            <input type="text" name="psfa_theme_colors[<?php echo esc_attr( $theme_slug ); ?>][primary_color]" value="<?php echo esc_attr( $primary_color ); ?>" class="psfa-color-picker" data-default-color="<?php echo esc_attr( $default_colors['primary_color'] ?? '' ); ?>">
                        </td>
                    </tr>
                    <tr>
                        <th scope="row" style="padding: 8px 0; font-weight: 500;">Secondary Color <?php echo wp_kses_post( psfa_info_tip('Used for backgrounds, hover states, and secondary UI elements.') ); ?></th>
                        <td style="padding: 8px 0;">
                            <input type="text" name="psfa_theme_colors[<?php echo esc_attr( $theme_slug ); ?>][secondary_color]" value="<?php echo esc_attr( $secondary_color ); ?>" class="psfa-color-picker" data-default-color="<?php echo esc_attr( $default_colors['secondary_color'] ?? '' ); ?>">
                        </td>
                    </tr>
                    <tr>
                        <th scope="row" style="padding: 8px 0; font-weight: 500;">Button Background <?php echo wp_kses_post( psfa_info_tip('Background color for the "Buy on Amazon" button.') ); ?></th>
                        <td style="padding: 8px 0;">
                            <input type="text" name="psfa_theme_colors[<?php echo esc_attr( $theme_slug ); ?>][button_bg]" value="<?php echo esc_attr( $button_bg ); ?>" class="psfa-color-picker" data-default-color="<?php echo esc_attr( $default_colors['button_bg'] ?? '' ); ?>">
                        </td>
                    </tr>
                    <tr>
                        <th scope="row" style="padding: 8px 0; font-weight: 500;">Button Text <?php echo wp_kses_post( psfa_info_tip('Text color for the "Buy on Amazon" button. Should contrast with button background.') ); ?></th>
                        <td style="padding: 8px 0;">
                            <input type="text" name="psfa_theme_colors[<?php echo esc_attr( $theme_slug ); ?>][button_text]" value="<?php echo esc_attr( $button_text_color ); ?>" class="psfa-color-picker" data-default-color="<?php echo esc_attr( $default_colors['button_text'] ?? '' ); ?>">
                        </td>
                    </tr>
                    <tr>
                        <th scope="row" style="padding: 8px 0; font-weight: 500;">Text Color <?php echo wp_kses_post( psfa_info_tip('Main text color for product titles, descriptions, and other content.') ); ?></th>
                        <td style="padding: 8px 0;">
                            <input type="text" name="psfa_theme_colors[<?php echo esc_attr( $theme_slug ); ?>][text_color]" value="<?php echo esc_attr( $text_color ); ?>" class="psfa-color-picker" data-default-color="<?php echo esc_attr( $default_colors['text_color'] ?? '' ); ?>">
                        </td>
                    </tr>
                    <tr>
                        <th scope="row" style="padding: 8px 0; font-weight: 500;">Price Color <?php echo wp_kses_post( psfa_info_tip('Color for product prices. Often set to a bold color to draw attention.') ); ?></th>
                        <td style="padding: 8px 0;">
                            <input type="text" name="psfa_theme_colors[<?php echo esc_attr( $theme_slug ); ?>][price_color]" value="<?php echo esc_attr( $price_color ); ?>" class="psfa-color-picker" data-default-color="<?php echo esc_attr( $default_colors['price_color'] ?? '' ); ?>">
                        </td>
                    </tr>
                </table>
                <?php
            }
            ?>
            <?php else : ?>
            <ul style="margin: 15px 0; padding-left: 20px; color: #646970;">
                <li>Primary & secondary colors</li>
                <li>Button background & text colors</li>
                <li>Text & price colors</li>
                <li>Per-theme color customization</li>
            </ul>
            <div style="margin-top: 15px; padding: 8px 12px; background: #fff3cd; border-left: 3px solid #ffc107; border-radius: 3px;">
                <span class="description" style="font-size: 12px; color: #856404;">
                    <a href="<?php echo esc_url( $upgrade_url ); ?>" target="_blank" style="color: #2271b1; text-decoration: none; font-weight: 600;">Upgrade to Premium</a> to unlock this feature.
                </span>
            </div>
            <?php endif; ?>
        </div>
        
    </div>
    
    <?php
    // Enqueue WordPress color picker.
    wp_enqueue_style( 'wp-color-picker' );
    wp_enqueue_script( 'wp-color-picker' );
    ?>
    <script>
    jQuery(document).ready(function($) {
        if ($.fn.wpColorPicker) {
            $('.psfa-color-picker').each(function() {
                var $input = $(this);
                var currentValue = $input.val();
                var defaultColor = $input.data('default-color') || '';
                
                // If input is empty, temporarily set to default for visual display
                // but we'll clear it before form submission
                if (!currentValue && defaultColor) {
                    $input.val(defaultColor);
                }
                
                // Initialize color picker
                $input.wpColorPicker();
            });
            
            // Before form submission, clear inputs that match defaults
            $('form').on('submit', function() {
                $('.psfa-color-picker').each(function() {
                    var $input = $(this);
                    var currentValue = $input.val();
                    var defaultColor = $input.data('default-color') || '';
                    
                    // If the current value matches the default, clear it so default is used
                    if (currentValue && currentValue === defaultColor) {
                        $input.val('');
                    }
                });
            });
        }
    });
    </script>
    <?php
}

