<?php
/**
 * Admin Credentials tab renderer.
 *
 * Extracted from the main plugin class to keep responsibilities focused and
 * the main file smaller.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Render the Credentials tab contents.
 */
function psfa_render_credentials_tab() {
    $access_key_id = get_option( 'psfa_access_key_id', '' );
    $secret_access_key = get_option( 'psfa_secret_access_key', '' );
    $associate_tag = get_option( 'psfa_associate_tag', '' );
    ?>
    <div class="psfa-tab-section">
        <h2 style="margin-top: 0;">PA-API Credentials</h2>
        <p class="description">Enter your Amazon Product Advertising API credentials. Get them from <a href="https://webservices.amazon.com/paapi5/documentation/register-for-product-advertising-api.html" target="_blank">Amazon PA-API</a>.</p>
        <form action="options.php" method="post">
            <?php 
            settings_fields( 'psfa_settings' );
            ?>
            <div class="psfa-credentials-card">
                <div class="psfa-credential-field">
                    <label for="psfa_access_key_id" class="psfa-field-label">Access Key ID</label>
                    <div class="psfa-field-input-wrapper">
                        <input type="text" name="psfa_access_key_id" id="psfa_access_key_id" value="<?php echo esc_attr( $access_key_id ); ?>" class="regular-text" />
                    </div>
                </div>
                <div class="psfa-credential-field">
                    <label for="psfa_secret_access_key" class="psfa-field-label">Secret Access Key</label>
                    <div class="psfa-field-input-wrapper">
                        <input type="password" name="psfa_secret_access_key" id="psfa_secret_access_key" value="<?php echo esc_attr( $secret_access_key ); ?>" class="regular-text" />
                    </div>
                </div>
                <div class="psfa-credential-field">
                    <label for="psfa_associate_tag" class="psfa-field-label">Associate Tag</label>
                    <div class="psfa-field-input-wrapper">
                        <input type="text" name="psfa_associate_tag" id="psfa_associate_tag" value="<?php echo esc_attr( $associate_tag ); ?>" class="regular-text" />
                    </div>
                </div>
            </div>
            <?php 
            if ( function_exists( 'submit_button' ) ) {
                submit_button( 'Save Settings' );
            } else {
                echo '<input type="submit" name="submit" class="button button-primary" value="Save Settings">';
            }
            ?>
        </form>
    </div>

    <div class="psfa-tab-section" style="margin-top: 20px;">
        <h3 style="margin-top: 0;">
            <span class="dashicons dashicons-info" style="color: #0073aa;"></span>
            About PA-API Data
        </h3>
        <div class="notice notice-info inline" style="margin: 0; padding: 12px;">
            <p style="margin: 0 0 8px 0;"><strong>Important:</strong> Amazon PA-API data is cached and may not reflect real-time information on Amazon's website.</p>
            <p style="margin: 0 0 8px 0;">The following data may be slightly outdated:</p>
            <ul style="margin: 0 0 8px 20px; list-style: disc;">
                <li><strong>Availability/Stock Status</strong> – Can lag hours behind actual availability</li>
                <li><strong>Prices &amp; Discounts</strong> – May differ slightly from current Amazon prices</li>
                <li><strong>Sales Rank</strong> – Updated periodically, not in real-time</li>
                <li><strong>Prime Eligibility</strong> – Usually accurate but can change</li>
            </ul>
            <p style="margin: 0;">This is a limitation of Amazon's API, not this plugin. For the most accurate data, users should always verify on Amazon before purchasing.</p>
        </div>
    </div>
    <?php
}

