<?php
/**
 * Admin Styles - Minimal CSS for Tailwind integration
 * Tailwind CSS is loaded via CDN, this file only provides minimal overrides
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Get minimal admin styles (Tailwind handles the rest via CDN)
 */
function psfa_get_tailwind_admin_styles() {
    return '
/* Minimal overrides for WP admin compatibility */
#psfa-admin-root {
    margin-left: -20px;
    position: absolute;
    top: 0;
    width: -webkit-fill-available;
}

#psfa-admin-root * {
    box-sizing: border-box;
}

/* Hide default WP notices inside our container */
#psfa-admin-root .notice:not(.psfa-notice) {
    display: none;
}
.wp-core-ui .notice.is-dismissible,
div.fs-notice.promotion, div.fs-notice.success, div.fs-notice.updated {
    place-self: flex-end;
    z-index: 9;
}
#wpfooter {
    z-index: -1;
}
/* Global link styles - no underline, no focus outline */
#psfa-admin-root a {
    text-decoration: none;
}
#psfa-admin-root a:focus {
    outline: none;
    box-shadow: none;
}

/* Toggle switch styles */
.psfa-toggle {
    position: relative;
    width: 44px;
    height: 24px;
    flex-shrink: 0;
}
.psfa-toggle input {
    opacity: 0;
    width: 0;
    height: 0;
}
.psfa-toggle-slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #d1d5db;
    transition: 0.2s;
    border-radius: 24px;
}
.psfa-toggle-slider:before {
    position: absolute;
    content: "";
    height: 18px;
    width: 18px;
    left: 3px;
    bottom: 3px;
    background-color: white;
    transition: 0.2s;
    border-radius: 50%;
    box-shadow: 0 1px 3px rgba(0,0,0,0.2);
}
.psfa-toggle input:checked + .psfa-toggle-slider {
    background-color: #2872FA;
}
.psfa-toggle input:checked + .psfa-toggle-slider:before {
    transform: translateX(20px);
}
.psfa-toggle input:focus + .psfa-toggle-slider {
    box-shadow: 0 0 0 2px rgba(40, 114, 250, 0.2);
}

/* Theme card hover - only show opacity effect on available themes */
.psfa-theme-preview-img {
    cursor: default !important;
}
.psfa-theme-preview-img:hover {
    opacity: 1 !important;
}
.psfa-theme-card .psfa-theme-preview-img {
    cursor: pointer !important;
}
.psfa-theme-card .psfa-theme-preview-img:hover {
    opacity: 0.8 !important;
}

/* WordPress color picker fixes - reset box-sizing for iris elements */
.wp-picker-container,
.wp-picker-container *,
.iris-picker,
.iris-picker * {
    box-sizing: content-box !important;
}
.wp-picker-holder {
    position: absolute;
    z-index: 100;
    top: auto;
    left: 0;
}
.wp-picker-input-wrap {
    position: absolute;
    background-color: #ffffff;
    top: 0;
    left: 0;
}
.wp-picker-container .wp-color-result,
.wp-picker-container .wp-color-result:hover,
.wp-picker-container .wp-color-result:focus {
    border-color: transparent !important;
}
';
}

/**
 * Enqueue Tailwind CSS for admin
 */
function psfa_enqueue_tailwind_admin() {
    // Enqueue pre-compiled Tailwind CSS (WP.org compliant - no external resources)
    wp_enqueue_style(
        'psfa-tailwind-admin',
        PSFA_PLUGIN_URL . 'assets/css/tailwind-admin.css',
        array(),
        PSFA_VERSION
    );
    
    // Register a script handle for inline scripts
    wp_register_script('psfa-admin-card-handlers', '', array(), PSFA_VERSION, true);
    wp_enqueue_script('psfa-admin-card-handlers');
    
    // Card selection handlers for theme and layout cards
    $theme_card_script = "
    document.addEventListener('DOMContentLoaded', function() {
        /**
         * Theme card click handler
         * Allows clicking anywhere on the card to select the theme (except preview button)
         */
        document.querySelectorAll('.psfa-theme-card').forEach(function(card) {
            card.addEventListener('click', function(e) {
                // Skip if clicking the preview button
                if (e.target.closest('.psfa-theme-preview-button')) return;
                
                var radio = card.querySelector('.psfa-theme-radio');
                if (radio) {
                    // Select this theme's radio input
                    radio.checked = true;
                    
                    // Reset all cards to unselected state (remove both tw-ring-1 and tw-ring-2)
                    document.querySelectorAll('.psfa-theme-card').forEach(function(c) {
                        c.classList.remove('tw-border-brand-primary', 'tw-ring-1', 'tw-ring-2', 'tw-ring-brand-primary');
                        c.classList.add('tw-border-gray-200', 'tw-shadow-sm');
                    });
                    
                    // Apply selected state to clicked card (tw-ring-1 matches PHP template)
                    card.classList.remove('tw-border-gray-200', 'tw-shadow-sm');
                    card.classList.add('tw-border-brand-primary', 'tw-ring-1', 'tw-ring-brand-primary');
                }
            });
        });
        
        /**
         * Layout card click handler
         * Allows clicking anywhere on the card to select the layout
         */
        document.querySelectorAll('.psfa-layout-card').forEach(function(card) {
            card.addEventListener('click', function(e) {
                var radio = card.querySelector('.psfa-layout-radio');
                if (radio) {
                    // Select this layout's radio input
                    radio.checked = true;
                    
                    // Reset all cards to unselected state (remove both tw-ring-1 and tw-ring-2)
                    document.querySelectorAll('.psfa-layout-card').forEach(function(c) {
                        c.classList.remove('tw-border-brand-primary', 'tw-ring-1', 'tw-ring-2', 'tw-ring-brand-primary');
                        c.classList.add('tw-border-gray-200', 'tw-shadow-sm');
                    });
                    
                    // Apply selected state to clicked card (tw-ring-1 for consistency)
                    card.classList.remove('tw-border-gray-200', 'tw-shadow-sm');
                    card.classList.add('tw-border-brand-primary', 'tw-ring-1', 'tw-ring-brand-primary');
                }
            });
        });
    });
    ";
    wp_add_inline_script('psfa-admin-card-handlers', $theme_card_script);
    
    // Load Rubik font (Google Fonts is allowed as it's a standard font service)
    // phpcs:ignore PluginCheck.CodeAnalysis.EnqueuedResourceOffloading.OffloadedContent -- Google Fonts is an industry-standard font service.
    wp_enqueue_style(
        'psfa-rubik-font',
        'https://fonts.googleapis.com/css2?family=Rubik:wght@400;500;600;700&display=swap',
        array(),
        null
    );
}
