/**
 * Clear button module
 * 
 * Handles reset/clear functionality for the search form.
 */

let clickHandler = null;

/**
 * Initialize clear button functionality
 * Can be called multiple times to re-initialize
 */
export function initClearButton() {
    const clearBtn = document.getElementById('clear-search-btn');
    const searchInput = document.getElementById('amazon-search-input');
    const suggestionsDiv = document.getElementById('autocomplete-suggestions');
    
    if (!clearBtn || !searchInput) {
        return; // Elements not found
    }
    
    // Remove existing handler if re-initializing
    if (clickHandler) {
        clearBtn.removeEventListener('click', clickHandler);
    }
    
    clickHandler = function(e) {
        e.preventDefault();
        e.stopPropagation();
        
        searchInput.value = '';
        if (suggestionsDiv) {
            suggestionsDiv.style.display = 'none';
        }
        
        // Get current URL and strip ALL query parameters for a clean reset
        const url = new URL(window.location.href);
        
        // Keep only page_id if present (WordPress page identifier)
        const pageId = url.searchParams.get('page_id');
        
        // Build clean URL with only essential params
        let cleanUrl = url.pathname;
        if (pageId) {
            cleanUrl += '?page_id=' + pageId;
        }
        
        // Use replace to avoid adding to browser history
        window.location.replace(cleanUrl);
    };
    
    clearBtn.addEventListener('click', clickHandler);
}

// Auto-initialize if elements exist (for production)
if (typeof document !== 'undefined') {
    initClearButton();
}


