<?php
/**
 * Public template.
 *
 * Variables:
 * @var array $atts
 * @var array $cookies
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<div class="cookie-manager-public">
    <?php if ( ! empty( $atts['title'] ) ) : ?>
        <h2 class="cookie-manager-title"><?php echo esc_html( $atts['title'] ); ?></h2>
    <?php endif; ?>

    <?php if ( isset( $atts['show_detected'] ) && 'true' === (string) $atts['show_detected'] ) : ?>
        <div class="cookie-detection-section">
            <h3><?php echo esc_html__( '🍪 Cookies currently stored in your browser', 'oxicat-cookies-manager' ); ?></h3>
            <p class="cookie-intro"><?php echo esc_html__( 'This section displays, in real time, the cookies stored in your browser for this site.', 'oxicat-cookies-manager' ); ?></p>
            <div id="detected-cookies-public"></div>
            <button id="refresh-detected-cookies" class="cookie-btn"><?php echo esc_html__( '🔄 Refresh list', 'oxicat-cookies-manager' ); ?></button>
        </div>
    <?php endif; ?>

    <div class="cookie-documentation-section">
        <h3><?php echo esc_html__( '📋 Full cookie documentation', 'oxicat-cookies-manager' ); ?></h3>
        <p class="cookie-intro"><?php echo esc_html__( 'Below you can find detailed information about cookies used on this website, in accordance with GDPR.', 'oxicat-cookies-manager' ); ?></p>

        <?php if ( empty( $cookies ) ) : ?>
            <p class="cookie-empty"><?php echo esc_html__( 'No documented cookie yet.', 'oxicat-cookies-manager' ); ?></p>
        <?php else : ?>
            <?php
            $categories = array(
                'necessary' => array(
                    'label'  => __( '✅ Strictly necessary cookies', 'oxicat-cookies-manager' ),
                    'desc'   => __( 'These cookies are essential for the website to work and cannot be switched off.', 'oxicat-cookies-manager' ),
                    'cookies'=> array(),
                ),
                'functional' => array(
                    'label'  => __( '⚙️ Functional cookies', 'oxicat-cookies-manager' ),
                    'desc'   => __( 'These cookies allow enhanced functionality and personalization.', 'oxicat-cookies-manager' ),
                    'cookies'=> array(),
                ),
                'analytics' => array(
                    'label'  => __( '📊 Analytics cookies', 'oxicat-cookies-manager' ),
                    'desc'   => __( 'These cookies help us understand how the site is used so we can improve it.', 'oxicat-cookies-manager' ),
                    'cookies'=> array(),
                ),
                'marketing' => array(
                    'label'  => __( '🎯 Marketing cookies', 'oxicat-cookies-manager' ),
                    'desc'   => __( 'These cookies may be used to build a profile of your interests and show relevant ads.', 'oxicat-cookies-manager' ),
                    'cookies'=> array(),
                ),
            );

            foreach ( $cookies as $cookie ) {
                if ( isset( $categories[ $cookie->category ] ) ) {
                    $categories[ $cookie->category ]['cookies'][] = $cookie;
                }
            }

            foreach ( $categories as $cat_key => $cat_data ) :
                if ( empty( $cat_data['cookies'] ) ) {
                    continue;
                }
                ?>
                <div class="cookie-category-group category-<?php echo esc_attr( $cat_key ); ?>">
                    <h4 class="category-title">
                        <?php echo esc_html( $cat_data['label'] ); ?>
                        <span class="cookie-count"><?php echo esc_html( (string) count( $cat_data['cookies'] ) ); ?></span>
                    </h4>
                    <p class="category-description"><?php echo esc_html( $cat_data['desc'] ); ?></p>

                    <div class="cookies-list">
                        <?php foreach ( $cat_data['cookies'] as $cookie ) : ?>
                            <div class="cookie-card">
                                <div class="cookie-card-header">
                                    <strong class="cookie-name"><?php echo esc_html( wp_unslash( $cookie->cookie_name ) ); ?></strong>
                                    <span class="cookie-provider"><?php echo esc_html( wp_unslash( $cookie->provider ) ); ?></span>
                                </div>
                                <div class="cookie-card-body">
                                    <div class="cookie-info-row">
                                        <span class="cookie-label"><?php echo esc_html__( '📝 Purpose:', 'oxicat-cookies-manager' ); ?></span>
                                        <span class="cookie-value"><?php echo wp_kses_post( nl2br( wp_unslash( $cookie->purpose ) ) ); ?></span>
                                    </div>
                                    <div class="cookie-info-row">
                                        <span class="cookie-label"><?php echo esc_html__( '⏱️ Retention period:', 'oxicat-cookies-manager' ); ?></span>
                                        <span class="cookie-value"><?php echo esc_html( wp_unslash( $cookie->duration ) ); ?></span>
                                    </div>
                                    <?php if ( ! empty( $cookie->more_info_url ) ) : ?>
                                        <div class="cookie-info-row">
                                            <span class="cookie-label"><?php echo esc_html__( 'ℹ️ More information:', 'oxicat-cookies-manager' ); ?></span>
                                            <span class="cookie-value">
                                                <a href="<?php echo esc_url( $cookie->more_info_url ); ?>" target="_blank" rel="noopener">
                                                    <?php echo esc_html__( 'Privacy policy →', 'oxicat-cookies-manager' ); ?>
                                                </a>
                                            </span>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div>
