<?php
/**
 * Admin page template.
 *
 * @var array $cookies
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<div class="wrap cookie-manager-admin">
    <h1><?php echo esc_html__( '🍪 Cookie Manager', 'oxicat-cookies-manager' ); ?></h1>

    <div class="cookie-manager-intro">
        <p><?php echo esc_html__( 'Manage all cookies used on your website to stay GDPR compliant. Add the required information for each detected cookie.', 'oxicat-cookies-manager' ); ?></p>
        <p>
            <strong><?php echo esc_html__( 'Shortcode to use:', 'oxicat-cookies-manager' ); ?></strong>
            <code>[cookie_manager]</code>
        </p>
    </div>

    <div class="cookie-manager-actions">
        <button id="detect-cookies-btn" class="button button-primary">
            <?php echo esc_html__( '🔍 Detect cookies automatically', 'oxicat-cookies-manager' ); ?>
        </button>
        <button id="add-cookie-btn" class="button button-secondary">
            <?php echo esc_html__( '➕ Add a cookie manually', 'oxicat-cookies-manager' ); ?>
        </button>
    </div>

    <div id="detected-cookies" style="display:none; margin:20px 0;"></div>

    <h2>
        <?php
        /* translators: %d is the number of cookies. */
        echo esc_html( sprintf( __( 'Documented cookies (%d)', 'oxicat-cookies-manager' ), is_array( $cookies ) ? count( $cookies ) : 0 ) );
        ?>
    </h2>

    <table class="wp-list-table widefat fixed striped">
        <thead>
            <tr>
                <th width="15%"><?php echo esc_html__( 'Cookie name', 'oxicat-cookies-manager' ); ?></th>
                <th width="30%"><?php echo esc_html__( 'Purpose', 'oxicat-cookies-manager' ); ?></th>
                <th width="10%"><?php echo esc_html__( 'Duration', 'oxicat-cookies-manager' ); ?></th>
                <th width="15%"><?php echo esc_html__( 'Provider', 'oxicat-cookies-manager' ); ?></th>
                <th width="12%"><?php echo esc_html__( 'Category', 'oxicat-cookies-manager' ); ?></th>
                <th width="10%"><?php echo esc_html__( 'Actions', 'oxicat-cookies-manager' ); ?></th>
            </tr>
        </thead>
        <tbody id="cookies-table-body">
        <?php if ( empty( $cookies ) ) : ?>
            <tr>
                <td colspan="6" style="text-align:center; padding:40px;">
                    <em><?php echo esc_html__( 'No documented cookie yet. Start by detecting cookies or add one manually.', 'oxicat-cookies-manager' ); ?></em>
                </td>
            </tr>
        <?php else : ?>
            <?php foreach ( $cookies as $cookie ) : ?>
                <tr data-cookie-id="<?php echo esc_attr( $cookie->id ); ?>">
                    <td><strong><?php echo esc_html( $cookie->cookie_name ); ?></strong></td>
                    <td><?php echo wp_kses_post( substr( wp_unslash( $cookie->purpose ), 0, 80 ) ) . ( strlen( $cookie->purpose ) > 80 ? '&hellip;' : '' ); ?></td>
                    <td><?php echo esc_html( wp_unslash( $cookie->duration ) ); ?></td>
                    <td><?php echo esc_html( wp_unslash( $cookie->provider ) ); ?></td>
                    <td><?php echo wp_kses_post( $this->get_category_badge( (string) $cookie->category ) ); ?></td>
                    <td>
                        <button
                            class="button button-small edit-cookie"
                            data-id="<?php echo esc_attr( $cookie->id ); ?>"
                            data-name="<?php echo esc_attr( $cookie->cookie_name ); ?>"
                            data-purpose="<?php echo esc_attr( $cookie->purpose ); ?>"
                            data-duration="<?php echo esc_attr( $cookie->duration ); ?>"
                            data-provider="<?php echo esc_attr( $cookie->provider ); ?>"
                            data-category="<?php echo esc_attr( $cookie->category ); ?>"
                            data-url="<?php echo esc_attr( $cookie->more_info_url ); ?>"
                        >
                            <?php echo esc_html__( '✏️ Edit', 'oxicat-cookies-manager' ); ?>
                        </button>
                        <button class="button button-small button-link-delete delete-cookie" data-id="<?php echo esc_attr( $cookie->id ); ?>">
                            <?php echo esc_html__( '🗑️ Delete', 'oxicat-cookies-manager' ); ?>
                        </button>
                    </td>
                </tr>
            <?php endforeach; ?>
        <?php endif; ?>
        </tbody>
    </table>
</div>

<div id="cookie-modal" class="cookie-modal" style="display:none;">
    <div class="cookie-modal-content">
        <button type="button" class="cookie-modal-close" aria-label="<?php echo esc_attr__( 'Close', 'oxicat-cookies-manager' ); ?>">&times;</button>
        <h2 id="modal-title"><?php echo esc_html__( 'Add a cookie', 'oxicat-cookies-manager' ); ?></h2>

        <form id="cookie-form">
            <input type="hidden" id="cookie-id" name="cookie_id" value="">

            <table class="form-table">
                <tr>
                    <th><label for="cookie-name"><?php echo esc_html__( 'Cookie name *', 'oxicat-cookies-manager' ); ?></label></th>
                    <td><input type="text" id="cookie-name" name="cookie_name" class="regular-text" required></td>
                </tr>

                <tr>
                    <th><label for="cookie-purpose"><?php echo esc_html__( 'Purpose *', 'oxicat-cookies-manager' ); ?></label></th>
                    <td><textarea id="cookie-purpose" name="purpose" class="large-text" rows="4" required></textarea></td>
                </tr>

                <tr>
                    <th><label for="cookie-duration"><?php echo esc_html__( 'Duration *', 'oxicat-cookies-manager' ); ?></label></th>
                    <td><input type="text" id="cookie-duration" name="duration" class="regular-text" required></td>
                </tr>

                <tr>
                    <th><label for="cookie-provider"><?php echo esc_html__( 'Provider *', 'oxicat-cookies-manager' ); ?></label></th>
                    <td><input type="text" id="cookie-provider" name="provider" class="regular-text" required></td>
                </tr>

                <tr>
                    <th><label for="cookie-category"><?php echo esc_html__( 'Category *', 'oxicat-cookies-manager' ); ?></label></th>
                    <td>
                        <select id="cookie-category" name="category" required>
                            <option value="necessary"><?php echo esc_html__( 'Necessary', 'oxicat-cookies-manager' ); ?></option>
                            <option value="functional"><?php echo esc_html__( 'Functional', 'oxicat-cookies-manager' ); ?></option>
                            <option value="analytics"><?php echo esc_html__( 'Analytics', 'oxicat-cookies-manager' ); ?></option>
                            <option value="marketing"><?php echo esc_html__( 'Marketing', 'oxicat-cookies-manager' ); ?></option>
                        </select>
                    </td>
                </tr>

                <tr>
                    <th><label for="cookie-url"><?php echo esc_html__( 'More info URL', 'oxicat-cookies-manager' ); ?></label></th>
                    <td><input type="url" id="cookie-url" name="more_info_url" class="large-text" placeholder="https://"></td>
                </tr>
            </table>

            <p class="submit">
                <button type="submit" class="button button-primary"><?php echo esc_html__( 'Save', 'oxicat-cookies-manager' ); ?></button>
                <button type="button" class="button cookie-cancel"><?php echo esc_html__( 'Cancel', 'oxicat-cookies-manager' ); ?></button>
            </p>
        </form>
    </div>
</div>
