<?php
/**
 * Plugin Name: Oxicat Cookies Manager
 * Plugin URI: https://www.oxicat.com
 * Description: Manage and publish a GDPR-compliant cookie inventory with an admin interface and a public shortcode.
 * Version: 1.0.1
 * Author: ofredon
 * Text Domain: oxicat-cookies-manager
 * Domain Path: /languages
 * License: GPL-2.0-or-later
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define( 'OXICAT_COOKIES_MANAGER_VERSION', '1.0.1' );
define( 'OXICAT_COOKIES_MANAGER_FILE', __FILE__ );
define( 'OXICAT_COOKIES_MANAGER_DIR', plugin_dir_path( __FILE__ ) );
define( 'OXICAT_COOKIES_MANAGER_URL', plugin_dir_url( __FILE__ ) );

require_once OXICAT_COOKIES_MANAGER_DIR . 'includes/class-plugin.php';

function oxicat_cookies_manager() {
    return \OXICAT\CookiesManager\Plugin::instance();
}

oxicat_cookies_manager();

// Add "Buy Me a Coffee" support link in plugin action links
add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), function ( $links ) {

    $links[] = sprintf(
        '<a href="%s" target="_blank" rel="noopener noreferrer">☕ %s</a>',
        esc_url( 'https://buymeacoffee.com/oxicat' ),
        esc_html__( 'Support the plugin', 'oxicat-cookies-manager' )
    );

    return $links;
});