<?php
namespace OXICAT\CookiesManager\PublicSite;

use OXICAT\CookiesManager\Plugin;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class PublicSite {

    /** @var Plugin */
    private $plugin;

    public function __construct( Plugin $plugin ) {
        $this->plugin = $plugin;
        add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_assets' ) );
    }

    public function enqueue_assets() : void {
        wp_enqueue_style(
            'oxicat-cookies-manager-public',
            OXICAT_COOKIES_MANAGER_URL . 'assets/css/public.css',
            array(),
            OXICAT_COOKIES_MANAGER_VERSION
        );

        wp_enqueue_script(
            'oxicat-cookies-manager-public',
            OXICAT_COOKIES_MANAGER_URL . 'assets/js/public.js',
            array(),
            OXICAT_COOKIES_MANAGER_VERSION,
            true
        );

        wp_localize_script(
            'oxicat-cookies-manager-public',
            'OXICAT_CM_PUBLIC',
            array(
                'i18n' => array(
                    'noBrowserCookies' => __( 'No cookies detected in your browser for this site.', 'oxicat-cookies-manager' ),
                ),
            )
        );
    }

    public function render_cookie_table( $atts ) : string {
        global $wpdb;

        $atts = shortcode_atts(
            array(
                'title'         => __( 'Cookie list used on this site', 'oxicat-cookies-manager' ),
                'show_detected' => 'true',
            ),
            (array) $atts,
            'cookie_manager'
        );

        $cookies = $wpdb->get_results( "SELECT * FROM {$this->plugin->table_name} ORDER BY category ASC, cookie_name ASC" );

        ob_start();
        include OXICAT_COOKIES_MANAGER_DIR . 'templates/public-template.php';
        return (string) ob_get_clean();
    }
}
