<?php
namespace OXICAT\CookiesManager;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

require_once OXICAT_COOKIES_MANAGER_DIR . 'includes/admin/class-admin.php';
require_once OXICAT_COOKIES_MANAGER_DIR . 'includes/public/class-public.php';

final class Plugin {

    private static $instance = null;

    /** @var string */
    public $table_name;

    /** @var \OXICAT\CookiesManager\Admin\Admin */
    public $admin;

    /** @var \OXICAT\CookiesManager\PublicSite\PublicSite */
    public $public;

    public static function instance() : self {
        if ( null === self::$instance ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        global $wpdb;
        $this->table_name = $wpdb->prefix . 'cookie_manager';

        register_activation_hook( OXICAT_COOKIES_MANAGER_FILE, array( $this, 'activate' ) );

        $this->admin  = new Admin\Admin( $this );
        $this->public = new PublicSite\PublicSite( $this );

        add_shortcode( 'cookie_manager', array( $this->public, 'render_cookie_table' ) );

        add_action( 'wp_ajax_oxicat_cm_save_cookie', array( $this->admin, 'ajax_save_cookie' ) );
        add_action( 'wp_ajax_oxicat_cm_delete_cookie', array( $this->admin, 'ajax_delete_cookie' ) );
    }

    public function __clone() {}
    public function __wakeup() {}

    public function activate() : void {
        global $wpdb;
        $charset_collate = $wpdb->get_charset_collate();

        $sql = "CREATE TABLE IF NOT EXISTS {$this->table_name} (
            id mediumint(9) NOT NULL AUTO_INCREMENT,
            cookie_name varchar(255) NOT NULL,
            purpose text NOT NULL,
            duration varchar(100) NOT NULL,
            provider varchar(255) NOT NULL,
            category varchar(50) NOT NULL,
            more_info_url varchar(500) DEFAULT '',
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (id),
            UNIQUE KEY cookie_name (cookie_name)
        ) $charset_collate;";

        require_once ABSPATH . 'wp-admin/includes/upgrade.php';
        dbDelta( $sql );
    }
}
