(function() {
    function displayDetectedCookies() {
        const container = document.getElementById('detected-cookies-public');
        if (!container) return;
        
        const cookies = document.cookie.split(';').map(c => {
            const parts = c.trim().split('=');
            return {
                name: parts[0].trim(),
                value: parts.slice(1).join('=') || ''
            };
        }).filter(c => c.name);
        
        if (cookies.length === 0) {
            container.innerHTML = '<p style="text-align: center; padding: 30px; color: #999;">' + OXICAT_CM_PUBLIC.i18n.noBrowserCookies + '</p>';
            return;
        }
        
        let html = '';
        cookies.forEach(cookie => {
            html += '<div class="detected-cookie-live">';
            html += '<div><strong>' + escapeHtml(cookie.name) + '</strong></div>';
            html += '<div><small>' + escapeHtml(cookie.value.substring(0, 60)) + (cookie.value.length > 60 ? '...' : '') + '</small></div>';
            html += '</div>';
        });
        
        container.innerHTML = html;
    }
    
    function escapeHtml(text) {
        const div = document.createElement('div');
        div.textContent = text;
        return div.innerHTML;
    }
    
    // Afficher au chargement
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', displayDetectedCookies);
    } else {
        displayDetectedCookies();
    }
    
    // Bouton refresh
    const refreshBtn = document.getElementById('refresh-detected-cookies');
    if (refreshBtn) {
        refreshBtn.addEventListener('click', displayDetectedCookies);
    }
})();
