jQuery(document).ready(function($) {
    
    // Detect cookies
    $('#detect-cookies-btn').on('click', function() {
        const btn = $(this);
        btn.prop('disabled', true).text(OXICAT_CM.i18n.detecting);
        
        const cookies = document.cookie.split(';').map(c => {
            const parts = c.trim().split('=');
            return {
                name: parts[0].trim(),
                value: parts.slice(1).join('=') || ''
            };
        }).filter(c => c.name);
        
        if (cookies.length === 0) {
            alert(OXICAT_CM.i18n.noCookiesDetected);
            btn.prop('disabled', false).text(OXICAT_CM.i18n.detectButton);
            return;
        }
        
        let html = '<h3>' + OXICAT_CM.i18n.detectedTitle.replace('%d', cookies.length) + '</h3>';
        html += '<p>' + OXICAT_CM.i18n.clickToAdd + '</p>';
        
        cookies.forEach(function(cookie) {
            html += '<div class="detected-cookie-item">';
            html += '<div class="detected-cookie-info">';
            html += '<strong>' + cookie.name + '</strong>';
            html += '<small>' + cookie.value.substring(0, 50) + (cookie.value.length > 50 ? '...' : '') + '</small>';
            html += '</div>';
            html += '<div class="detected-cookie-actions">';
            html += '<button class="button button-primary document-cookie" data-name="' + cookie.name + '">' + OXICAT_CM.i18n.documentButton + '</button>';
            html += '</div>';
            html += '</div>';
        });
        
        $('#detected-cookies').html(html).slideDown();
        btn.prop('disabled', false).text(OXICAT_CM.i18n.detectButton);
    });
    
    // Documenter un cookie détecté
    $(document).on('click', '.document-cookie', function() {
        const cookieName = $(this).data('name');
        $('#cookie-name').val(cookieName);
        openModal(cookieName);
    });
    
    // Ajouter un cookie manuellement
    $('#add-cookie-btn').on('click', function() {
        openModal(OXICAT_CM.i18n.addCookieTitle);
    });
    
    // Éditer un cookie
    $(document).on('click', '.edit-cookie', function() {
        const btn = $(this);
        $('#cookie-id').val(btn.data('id'));
        $('#cookie-name').val(btn.data('name'));
        $('#cookie-purpose').val(btn.data('purpose'));
        $('#cookie-duration').val(btn.data('duration'));
        $('#cookie-provider').val(btn.data('provider'));
        $('#cookie-category').val(btn.data('category'));
        $('#cookie-url').val(btn.data('url'));
        
        openModal(OXICAT_CM.i18n.editCookieTitle.replace('%s', btn.data('name')));
    });
    
    // Supprimer un cookie
    $(document).on('click', '.delete-cookie', function() {
        if (!confirm(OXICAT_CM.i18n.confirmDelete)) {
            return;
        }
        
        const cookieId = $(this).data('id');
        
        $.post(OXICAT_CM.ajaxUrl, { nonce: OXICAT_CM.nonce, 
        action: 'oxicat_cm_delete_cookie',
            cookie_id: cookieId
        }, function(response) {
            if (response.success) {
                $('tr[data-cookie-id="' + cookieId + '"]').fadeOut(function() {
                    $(this).remove();
                });
            } else {
                alert(OXICAT_CM.i18n.deleteFailed);
            }
        });
    });
    
    // Soumettre le formulaire
    $('#cookie-form').on('submit', function(e) {
        e.preventDefault();
        
        const formData = { nonce: OXICAT_CM.nonce, 
        action: 'oxicat_cm_save_cookie',
            cookie_id: $('#cookie-id').val(),
            cookie_name: $('#cookie-name').val(),
            purpose: $('#cookie-purpose').val(),
            duration: $('#cookie-duration').val(),
            provider: $('#cookie-provider').val(),
            category: $('#cookie-category').val(),
            more_info_url: $('#cookie-url').val()
        };
        
        $.post(OXICAT_CM.ajaxUrl, formData, function(response) {
            if (response.success) {
                alert(OXICAT_CM.i18n.savedOk);
                location.reload();
            } else {
                alert(OXICAT_CM.i18n.saveFailed + (response && response.data ? ' ' + response.data : ''));
            }
        });
    });
    
    // Annuler
    $(document).on('click', '.cookie-cancel', function() {
        closeModal();
    });
    
    // Fermer la modal
    $(document).on('click', '.cookie-modal-close', function() {
        closeModal();
    });
    
    // Fermer en cliquant en dehors
    $(window).on('click', function(e) {
        if ($(e.target).hasClass('cookie-modal')) {
            closeModal();
        }
    });
    
    function openModal(title) {
        $('#modal-title').text(title);
        $('#cookie-modal').fadeIn();
    }
    
    function closeModal() {
        $('#cookie-modal').fadeOut();
        $('#cookie-form')[0].reset();
        $('#cookie-id').val('');
    }
});
