(function ($) {
    'use strict';

    $(function () {
        if (typeof overseasExpressAdmin === 'undefined') {
            return;
        }

        var timer;
        var $apiField  = $('#api_key');
        var $layoutSel = $('#label_layout');

        function fetchLayouts(apiKey, selectedLayout) {
            selectedLayout = selectedLayout || '';

            if (!apiKey) {
                return;
            }

            $layoutSel
                .html('<option>' + overseasExpressAdmin.loadingLabel + '</option>')
                .prop('disabled', true);

            $.ajax({
                method: 'POST',
                url: overseasExpressAdmin.ajaxUrl,
                data: {
                    action: 'overseas_express_fetch_layouts',
                    api_key: apiKey,
                    nonce: overseasExpressAdmin.nonce
                }
            })
                .done(function (response) {
                    if (response && response.success) {
                        var options    = '<option value="">' + overseasExpressAdmin.selectLabelText + '</option>';
                        var hasSelected = false;

                        response.data.forEach(function (layout) {
                            var isSelected = (String(layout.id) === String(selectedLayout));
                            if (isSelected) {
                                hasSelected = true;
                            }

                            options += '<option value="' + layout.id + '"' +
                                (isSelected ? ' selected="selected"' : '') +
                                '>' + layout.layoutName + '</option>';
                        });

                        $layoutSel
                            .html(options)
                            .prop('disabled', false);

                        if (!hasSelected) {
                            $layoutSel.val('');
                        }
                    } else {
                        var message = (response && response.data) ? response.data : overseasExpressAdmin.errorFetchText;
                        $layoutSel
                            .html('<option>' + message + '</option>')
                            .prop('disabled', true);
                    }
                })
                .fail(function () {
                    $layoutSel
                        .html('<option>' + overseasExpressAdmin.errorFetchText + '</option>')
                        .prop('disabled', true);
                });
        }

        // Debounced fetch on API key input
        $apiField.on('input', function () {
            clearTimeout(timer);
            var apiKey = $(this).val();

            timer = setTimeout(function () {
                fetchLayouts(apiKey);
            }, 500);
        });

        // Initial fetch if API key already present
        var initialApiKey = $apiField.val();
        if (initialApiKey) {
            fetchLayouts(initialApiKey, overseasExpressAdmin.initialLabelLayout || '');
        }
    });

})(jQuery);
