<?php
/**
 * Plugin Name: Hide or Show Out-of-Stock Products for WooCommerce
 * Description: Control which out-of-stock WooCommerce products stay visible or hidden — this plugin turns off WooCommerce’s global “Hide out of stock items” setting and lets you allow specific sold-out items to appear.
 * Author: 			Charlie Macaraeg
 * Version: 		2.0.3
 * Author URI:		https://profiles.wordpress.org/charliemac24
 * Requires at least: 6.0
 * Requires PHP: 7.4
 * License:         GPLv3
 * License URI:     https://www.gnu.org/licenses/gpl.txt
 * Text Domain:		out-of-stock-display-manager-for-woocommerce
 * Domain Path:		/languages
 *
 * @package		Out_of_Stock_Display_Manager_for_WooCommerce
 * @author		Charlie Macaraeg
 * @license		GPLv3
 * @link		https://www.gnu.org/licenses/gpl.txt
 *
 * Out of Stock Display Manager for WooCommerce is free software; you can redistribute it and/or modify it under the terms of the GNU
 * General Public License version 3, as published by the Free Software Foundation.  You may NOT assume
 * that you can use any other version of the GPL.e
 *
 * Out of Stock Display Manager for WooCommerce is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**/

if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
if (!defined('OOSDM_PLUGIN_VERSION')) {
    define('OOSDM_PLUGIN_VERSION', "2.0.3");
}
if (!defined('OOSDM_PLUGIN_DIR')) {
    define('OOSDM_PLUGIN_DIR', plugin_dir_path( __FILE__ ));
}
if (!defined('OOSDM_PLUGIN_URI')) {
    define('OOSDM_PLUGIN_URI', plugin_dir_url( __FILE__ ));
}

/**
 * On activation, force WooCommerce to show out-of-stock items (uncheck the global hide).
 */
function oosdm_activate() {
	if ( function_exists( 'update_option' ) ) {
		update_option( 'woocommerce_hide_out_of_stock_items', 'no' );
		update_option( 'oosdm_show_activation_notice', 'yes' );
	}
}
register_activation_hook( __FILE__, 'oosdm_activate' );

/**
 * Display a one-time activation notice with next steps.
 */
function oosdm_activation_admin_notice() {
	if ( ! is_admin() ) {
		return;
	}

	$should_show = get_option( 'oosdm_show_activation_notice' );
	if ( 'yes' !== $should_show ) {
		return;
	}

	delete_option( 'oosdm_show_activation_notice' );

	?>
	<div class="notice notice-info is-dismissible">
		<p><strong><?php esc_html_e( 'Out-of-Stock Visibility Control Enabled', 'out-of-stock-display-manager-for-woocommerce' ); ?></strong></p>
		<p><?php esc_html_e( 'WooCommerce only allows hiding out-of-stock products globally.', 'out-of-stock-display-manager-for-woocommerce' ); ?></p>
		<p><?php esc_html_e( 'This plugin lets you choose which out-of-stock products stay visible in:', 'out-of-stock-display-manager-for-woocommerce' ); ?></p>
		<ul>
			<li><?php esc_html_e( 'Shop pages', 'out-of-stock-display-manager-for-woocommerce' ); ?></li>
			<li><?php esc_html_e( 'Search results', 'out-of-stock-display-manager-for-woocommerce' ); ?></li>
			<li><?php esc_html_e( 'Or both', 'out-of-stock-display-manager-for-woocommerce' ); ?></li>
		</ul>
		<p><strong><?php esc_html_e( 'Next step:', 'out-of-stock-display-manager-for-woocommerce' ); ?></strong><br />
		<?php esc_html_e( 'Go to Products → Out of Stock Display Manager to set per-product visibility.', 'out-of-stock-display-manager-for-woocommerce' ); ?></p>
	</div>
	<?php
}
add_action( 'admin_notices', 'oosdm_activation_admin_notice' );

if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
    
    load_plugin_textdomain( 'out-of-stock-display-manager-for-woocommerce', false, basename( dirname( __FILE__ ) ) . '/languages/' );

    include_once(OOSDM_PLUGIN_DIR ."functions.php");

} else {
    
    function oosdm_admin_notice_woocommerce_required_error() {
        ?>
        <div class="notice notice-error is-dismissible">
            <p><?php _e( 'WooCommerce is required for <b>Out Of Stock Display Manager to work!</b>', 'out-of-stock-display-manager-for-woocommerce' ); ?></p>
        </div>
        <?php
    }
    add_action( 'admin_notices', 'oosdm_admin_notice_woocommerce_required_error' );

}




