<?php

echo '<div class="wrap">';
echo '<h1 class="wp-heading-inline">' . esc_html__( 'Out of Stock Visibility Manager', 'out-of-stock-display-manager-for-woocommerce' ) . '</h1>';
echo '<div class="notice notice-info"><p>' . wp_kses_post( sprintf( __( 'This tool manages per-product visibility exceptions for out-of-stock items. The WooCommerce global “Hide out of stock items” setting is overridden by this plugin. You can still view it at %sWooCommerce -> Settings -> Products -> Inventory%s.', 'out-of-stock-display-manager-for-woocommerce' ), '<a href="' . esc_url( admin_url( 'admin.php?page=wc-settings&tab=products&section=inventory' ) ) . '" target="_blank" rel="noopener">', '</a>' ) ) . '</p></div>';
echo '<hr class="wp-header-end">';
echo '<p class="oosdm-bulk-action"><select class="oosdm-visibility-bulk">
			<option value="--">' . esc_html__( 'Bulk actions', 'out-of-stock-display-manager-for-woocommerce' ) . '</option>
					<option value="visible">' . esc_html__( 'Shop and search results', 'out-of-stock-display-manager-for-woocommerce' ) . '</option>
					<option value="catalog">' . esc_html__( 'Shop only', 'out-of-stock-display-manager-for-woocommerce' ) . '</option>
					<option value="search">' . esc_html__( 'Search results only', 'out-of-stock-display-manager-for-woocommerce' ) . '</option>
					<option value="hidden">' . esc_html__( 'Hidden', 'out-of-stock-display-manager-for-woocommerce' ) . '</option>
				</select> <input type="submit" class="button oosdm-bulk-update" value="' . esc_attr__( 'Apply to selected products', 'out-of-stock-display-manager-for-woocommerce' ) . '"/><input type="hidden" class="oosdm-appy-bulk-ids" /> </p>';

$search_value = isset( $_GET['s'] ) ? sanitize_text_field( wp_unslash( $_GET['s'] ) ) : '';
echo '<p><form method="get" class="oosdm-search-box">
<input type="text" name="s" value="' . esc_attr( $search_value ) . '" placeholder="' . esc_attr__( 'Search out-of-stock products', 'out-of-stock-display-manager-for-woocommerce' ) . '"/>
<input type="hidden" value="' . esc_attr( 'product' ) . '" name="post_type"/> 
<input type="hidden" value="' . esc_attr( 'out-of-stock-display-manager-for-woocommerce' ) . '" name="page"/>
<input type="submit" class="button oosdm-search-button" value="' . esc_attr__( 'Search products', 'out-of-stock-display-manager-for-woocommerce' ) . '"/></form></p>';

	$paged = isset( $_GET['paged'] ) && is_numeric( $_GET['paged'] ) ? absint( $_GET['paged'] ) : 1;
	$args = array(
        'post_type' => 'product',
	    'posts_per_page' => 20,
	    'post_status' => 'publish',
	    'paged'=>$paged,
	    's'=> $search_value,
	    'meta_query' => array(
	       array(
	          'key' => '_stock_status',
	          'value' => 'outofstock',
	       )
	    )
    );

    $loop = new WP_Query( $args );
    $table_content = "";
    
    if($loop->have_posts()):
    while ( $loop->have_posts() ) : $loop->the_post();
    	
        global $product;

        $visibilities = get_the_terms(get_the_ID(),'product_visibility');
        $terms = get_the_terms( $product->get_id(), 'product_cat' );
        $categories_array = array();
        if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
	        foreach($terms as $term){
	        	$categories_array[] = $term->name;
	        }
        }
        $current_mode = oosdm_current_mode( $visibilities );
        $table_content .= "<tr>
        	<th scope=\"row\" class=\"check-column\">			
        		<label class=\"screen-reader-text\" for=\"cb-select-" . esc_attr( get_the_ID() ) . "\">
				</label>
			<input id=\"cb-select-" . esc_attr( get_the_ID() ) . "\" class=\"oosdm-cb\" type=\"checkbox\" name=\"post[]\" value=\"" . esc_attr( get_the_ID() ) . "\">			
			</th>
			<td class=\"name column-name has-row-actions column-primary\">
				<a href=\"" . esc_url( get_permalink() ) . "\">" . woocommerce_get_product_thumbnail('outofstock-custom-thumb') . "</a>
			</td>
			<td><strong><a href=\"" . esc_url( get_permalink() ) . "\" class=\"row-title\">" . esc_html( get_the_title() ) . "</a></strong></td>
			<td>" . esc_html( $product->get_sku() ) . "</td>
			<td>" . wp_kses_post( $product->get_price_html() ) . "</td>
			<td>" . esc_html( get_post_status( get_the_ID() ) ) . "</td>
			<td>" . esc_html( implode( ',', $categories_array ) ) . "</td>
			<td>" . esc_html( $current_mode ) . "</td>
			<td class=\"oosdm-set-visibility\"><select class=\"oosdm-visibility-" . esc_attr( get_the_ID() ) . "\">
					<option value=\"visible\" " . esc_attr( oosdm_selected_display( $visibilities, 'visible' ) ) . ">" . esc_html__( 'Shop and search results', 'out-of-stock-display-manager-for-woocommerce' ) . "</option>
					<option value=\"catalog\" " . esc_attr( oosdm_selected_display( $visibilities, 'catalog' ) ) . ">" . esc_html__( 'Shop only', 'out-of-stock-display-manager-for-woocommerce' ) . "</option>
					<option value=\"search\" " . esc_attr( oosdm_selected_display( $visibilities, 'search' ) ) . ">" . esc_html__( 'Search results only', 'out-of-stock-display-manager-for-woocommerce' ) . "</option>
					<option value=\"hidden\" " . esc_attr( oosdm_selected_display( $visibilities, 'hidden' ) ) . ">" . esc_html__( 'Hidden', 'out-of-stock-display-manager-for-woocommerce' ) . "</option>
				</select>
			</td>
			<td class=\"oosdm-actions-cell\"><button type=\"button\" class=\"button button-primary update_visibility\" data-id=\"" . esc_attr( get_the_ID() ) . "\">" . esc_html__( 'Update', 'out-of-stock-display-manager-for-woocommerce' ) . "</button> <span class=\"oosdm-loading oosdm-loading-" . esc_attr( get_the_ID() ) . "\"></span></td>
			</tr>";
    endwhile;

else:
	$table_content .="<tr><td colspan=\"10\" class=\"oosdm-norec\"><p>".esc_html(__('No records found!','out-of-stock-display-manager-for-woocommerce'))."</p></td></tr>";
endif;

    

    

    echo "<table class=\"oosdm wp-list-table widefat fixed striped table-view-list\">
    	<thead>
    		<tr>
    			<td id=\"cb\" class=\"manage-column column-cb check-column\"><input id=\"cb-select-all-1\" type=\"checkbox\"></td>

    			<th scope=\"col\" id=\"thumb\" class=\"manage-column column-thumb\"></th>
    			<th class=\"oosdm-product-name-col\">" . esc_html__( 'Products', 'out-of-stock-display-manager-for-woocommerce' ) . "</th>
    			<th>" . esc_html__( 'SKU', 'out-of-stock-display-manager-for-woocommerce' ) . "</th>
    			<th>" . esc_html__( 'Price', 'out-of-stock-display-manager-for-woocommerce' ) . "</th>
    			<th>" . esc_html__( 'Status', 'out-of-stock-display-manager-for-woocommerce' ) . "</th>
    			<th>" . esc_html__( 'Categories', 'out-of-stock-display-manager-for-woocommerce' ) . "</th>
    			<th>" . esc_html__( 'Current mode', 'out-of-stock-display-manager-for-woocommerce' ) . "</th>
    			<th class=\"oosdm-set-visibility-header\">" . esc_html__( 'Set visibility', 'out-of-stock-display-manager-for-woocommerce' ) . "</th>
    			<th class=\"oosdm-action\">" . esc_html__( 'Actions', 'out-of-stock-display-manager-for-woocommerce' ) . "</th>
    		</tr>
    	</thead>
    	<tbody>
    	".$table_content."
    	</tbody>
    </table>";
    echo "<div class=\"oosdm-pagination\">";
     echo paginate_links( array(
     	  'base' => '%_%',
          'format' => '?paged=%#%',
          'current' => $paged,
          'total' => $loop->max_num_pages,
          'prev_text' => '&laquo; Prev',
          'next_text' => 'Next &raquo;'
     ) );
     wp_reset_postdata();

echo "</div>";
