(function($){
	if ( typeof oosdmVars === 'undefined' ) {
		return;
	}

	const ajaxUrl = oosdmVars.ajaxUrl;
	const nonce = oosdmVars.nonce;
	const i18n = oosdmVars.i18n || {};

	const updateBulkIds = function() {
		const ids = [];
		$('.oosdm-cb:checked').each( function() {
			ids.push( $( this ).val() );
		});
		$('.oosdm-appy-bulk-ids').val( ids.join( ',' ) );
		return ids;
	};

	$('.update_visibility').on('click', function(e){
		e.preventDefault();
		const id = $(this).data('id');
		if ( ! id ) {
			return;
		}
		const visibility = $('.oosdm-visibility-' + id).val();
		const $status = $('.oosdm-loading-' + id);
		$status.text( i18n.processing || 'Processing...' ).addClass('is-visible');

		$.post( ajaxUrl, {
			action: 'oosdm_update_update_prod_display',
			id: id,
			visibility: visibility,
			nonce: nonce
		}).done( function( resp ) {
			if ( resp && resp.success ) {
				$status.text( i18n.success || 'Visibility updated!' ).addClass('is-visible');
				setTimeout( function(){ $status.removeClass('is-visible'); }, 2000 );
			} else {
				$status.text( i18n.error || 'Update failed.' ).addClass('is-visible');
			}
		}).fail( function() {
			$status.text( i18n.error || 'Update failed.' ).addClass('is-visible');
		});
	});

	$('.oosdm-bulk-update').on('click', function(e){
		e.preventDefault();
		const ids = updateBulkIds();
		if ( ! ids.length ) {
			window.alert( i18n.selectWarning || 'Select products to update.' );
			return;
		}
		const visibility = $('.oosdm-visibility-bulk').val();
		if ( visibility === '--' || ! visibility ) {
			window.alert( i18n.selectVisibility || 'Choose a visibility option.' );
			return;
		}
		ids.forEach( function( val ){
			$('.oosdm-loading-' + val).text( i18n.processing || 'Processing...' ).addClass('is-visible');
		});

		$.post( ajaxUrl, {
			action: 'oosdm_update_update_prod_display',
			id: ids,
			visibility: visibility,
			nonce: nonce
		}).done( function( resp ) {
			if ( resp && resp.success && resp.data && resp.data.updated ) {
				resp.data.updated.forEach( function( val ){
					$('.oosdm-loading-' + val).text( i18n.success || 'Visibility updated!' );
					$('.oosdm-visibility-' + val).val( resp.data.visibility );
					$('.oosdm-loading-' + val).addClass('is-visible');
					setTimeout( function(){ $('.oosdm-loading-' + val).removeClass('is-visible'); }, 2000 );
				});
			} else {
				ids.forEach( function( val ){
					$('.oosdm-loading-' + val).text( i18n.error || 'Update failed.' ).addClass('is-visible');
				});
			}
		}).fail( function() {
			ids.forEach( function( val ){
				$('.oosdm-loading-' + val).text( i18n.error || 'Update failed.' ).addClass('is-visible');
			});
		});
	});

	$('#cb-select-all-1').on('change', function(){
		$('.oosdm-cb').prop('checked', $(this).prop('checked'));
		updateBulkIds();
	});

	$('.oosdm-cb').on('change', function(){
		updateBulkIds();
	});
})(jQuery);
