<?php
/**
 * Plugin Name: ouRSVP - Event RSVP Forms
 * Description: Embed beautiful RSVP forms from ouRSVP.app into your WordPress website. Use the Gutenberg block or [oursvp] shortcode to easily add wedding or other event RSVP forms.
 * Version: 1.0.0
 * Author: ouRSVP
 * Author URI: https://www.oursvp.app
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: oursvp-event-rsvp-forms
 * Requires at least: 5.8
 * Requires PHP: 7.4
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('OURSVP_VERSION', '1.0.0');
define('OURSVP_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('OURSVP_PLUGIN_URL', plugin_dir_url(__FILE__));
define('OURSVP_WIDGET_URL', 'https://www.oursvp.app/widget/widget.js');

/**
 * Main plugin class
 */
class OurSVP_Plugin {

    /**
     * Instance of this class
     */
    private static $instance = null;

    /**
     * Get instance
     */
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * Constructor
     */
    private function __construct() {
        $this->load_dependencies();
    }

    /**
     * Load required files
     */
    private function load_dependencies() {
        require_once OURSVP_PLUGIN_DIR . 'includes/class-oursvp-shortcode.php';
        require_once OURSVP_PLUGIN_DIR . 'includes/class-oursvp-gutenberg.php';
    }

}

/**
 * Initialize the plugin
 */
function oursvp_init() {
    return OurSVP_Plugin::get_instance();
}

// Start the plugin
oursvp_init();
