<?php
/**
 * Gutenberg block integration for ouRSVP forms
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

class OurSVP_Gutenberg {

    /**
     * Constructor
     */
    public function __construct() {
        add_action('init', array($this, 'register_block'));
        add_action('enqueue_block_editor_assets', array($this, 'enqueue_block_editor_assets'));
    }

    /**
     * Register the Gutenberg block
     */
    public function register_block() {
        // Register the block type with dynamic rendering
        register_block_type('oursvp/rsvp-form', array(
            'api_version' => 2,
            'editor_script' => 'oursvp-block-editor',
            'render_callback' => array($this, 'render_block'),
            'attributes' => array(
                'eventId' => array(
                    'type' => 'string',
                    'default' => ''
                ),
                'showBackBtn' => array(
                    'type' => 'boolean',
                    'default' => false
                ),
                'showFullName' => array(
                    'type' => 'boolean',
                    'default' => false
                ),
                'language' => array(
                    'type' => 'string',
                    'default' => 'english'
                ),
                'limitSearch' => array(
                    'type' => 'boolean',
                    'default' => false
                ),
                // Style attributes
                'bgColor' => array(
                    'type' => 'string',
                    'default' => ''
                ),
                'headingColor' => array(
                    'type' => 'string',
                    'default' => ''
                ),
                'textColor' => array(
                    'type' => 'string',
                    'default' => ''
                ),
                'accentColor' => array(
                    'type' => 'string',
                    'default' => ''
                ),
                'buttonBgColor' => array(
                    'type' => 'string',
                    'default' => ''
                ),
                'buttonTextColor' => array(
                    'type' => 'string',
                    'default' => ''
                ),
                'buttonBorderColor' => array(
                    'type' => 'string',
                    'default' => ''
                ),
                'dateColor' => array(
                    'type' => 'string',
                    'default' => ''
                ),
                'buttonBorderRadius' => array(
                    'type' => 'string',
                    'default' => ''
                ),
                'buttonBorderWidth' => array(
                    'type' => 'string',
                    'default' => ''
                )
            )
        ));
    }

    /**
     * Enqueue block editor assets (for the admin interface)
     */
    public function enqueue_block_editor_assets() {
        wp_enqueue_script(
            'oursvp-block-editor',
            OURSVP_PLUGIN_URL . 'blocks/oursvp-block/index.js',
            array(
                'wp-blocks',
                'wp-element',
                'wp-components',
                'wp-block-editor',
                'wp-i18n'
            ),
            OURSVP_VERSION,
            true
        );

        // Enqueue editor styles
        wp_enqueue_style(
            'oursvp-block-editor-style',
            OURSVP_PLUGIN_URL . 'assets/css/editor.css',
            array('wp-edit-blocks'),
            OURSVP_VERSION
        );
    }

    /**
     * Render the block on the frontend
     *
     * @param array $attributes Block attributes
     * @return string HTML output
     */
    public function render_block($attributes) {
        // Reuse the shortcode rendering logic
        // This ensures consistency between shortcode and block output
        $shortcode_instance = new OurSVP_Shortcode();

        return $shortcode_instance->render_shortcode(array(
            'event_id' => isset($attributes['eventId']) ? $attributes['eventId'] : '',
            'show_back_btn' => isset($attributes['showBackBtn']) && $attributes['showBackBtn'] ? 'true' : 'false',
            'show_full_name' => isset($attributes['showFullName']) && $attributes['showFullName'] ? 'true' : 'false',
            'language' => isset($attributes['language']) ? $attributes['language'] : 'english',
            'limit_search' => isset($attributes['limitSearch']) && $attributes['limitSearch'] ? 'true' : 'false',
            // Style parameters
            'bg_color' => isset($attributes['bgColor']) ? $attributes['bgColor'] : '',
            'heading_color' => isset($attributes['headingColor']) ? $attributes['headingColor'] : '',
            'text_color' => isset($attributes['textColor']) ? $attributes['textColor'] : '',
            'accent_color' => isset($attributes['accentColor']) ? $attributes['accentColor'] : '',
            'button_bg_color' => isset($attributes['buttonBgColor']) ? $attributes['buttonBgColor'] : '',
            'button_text_color' => isset($attributes['buttonTextColor']) ? $attributes['buttonTextColor'] : '',
            'button_border_color' => isset($attributes['buttonBorderColor']) ? $attributes['buttonBorderColor'] : '',
            'date_color' => isset($attributes['dateColor']) ? $attributes['dateColor'] : '',
            'button_border_radius' => isset($attributes['buttonBorderRadius']) ? $attributes['buttonBorderRadius'] : '',
            'button_border_width' => isset($attributes['buttonBorderWidth']) ? $attributes['buttonBorderWidth'] : ''
        ));
    }
}

// Initialize the Gutenberg integration
new OurSVP_Gutenberg();
