/**
 * ouRSVP Gutenberg Block
 *
 * Provides a visual block editor interface for embedding ouRSVP forms
 */

(function (blocks, element, components, blockEditor, i18n) {
    var el = element.createElement;
    var registerBlockType = blocks.registerBlockType;
    var InspectorControls = blockEditor.InspectorControls;
    var PanelBody = components.PanelBody;
    var TextControl = components.TextControl;
    var ToggleControl = components.ToggleControl;
    var SelectControl = components.SelectControl;
    var ColorPalette = components.ColorPalette;
    var BaseControl = components.BaseControl;
    var __ = i18n.__;

    // Register the block
    registerBlockType('oursvp/rsvp-form', {
        title: __('ouRSVP Form', 'oursvp-event-rsvp-forms'),
        description: __('Embed an RSVP form from ouRSVP.app', 'oursvp-event-rsvp-forms'),
        category: 'embed',
        icon: 'forms',
        keywords: [__('rsvp', 'oursvp-event-rsvp-forms'), __('form', 'oursvp-event-rsvp-forms'), __('wedding', 'oursvp-event-rsvp-forms'), __('event', 'oursvp-event-rsvp-forms')],
        supports: {
            align: true,
            html: false
        },

        /**
         * Editor interface (what users see in Gutenberg)
         */
        edit: function (props) {
            var attributes = props.attributes;
            var setAttributes = props.setAttributes;

            // Extract attributes
            var eventId = attributes.eventId || '';
            var showBackBtn = attributes.showBackBtn || false;
            var showFullName = attributes.showFullName || false;
            var language = attributes.language || 'english';
            var limitSearch = attributes.limitSearch || false;
            // Style attributes
            var bgColor = attributes.bgColor || '';
            var headingColor = attributes.headingColor || '';
            var textColor = attributes.textColor || '';
            var dateColor = attributes.dateColor || '';
            var accentColor = attributes.accentColor || '';
            var buttonBgColor = attributes.buttonBgColor || '';
            var buttonTextColor = attributes.buttonTextColor || '';
            var buttonBorderColor = attributes.buttonBorderColor || '';
            var buttonBorderRadius = attributes.buttonBorderRadius || '';
            var buttonBorderWidth = attributes.buttonBorderWidth || '';

            return [
                // Sidebar settings panel
                el(
                    InspectorControls,
                    { key: 'inspector' },
                    el(
                        PanelBody,
                        {
                            title: __('RSVP Form Settings', 'oursvp-event-rsvp-forms'),
                            initialOpen: true
                        },
                        [
                            // Event ID field
                            el(TextControl, {
                                key: 'event-id',
                                label: __('Event ID', 'oursvp-event-rsvp-forms'),
                                value: eventId,
                                onChange: function (value) {
                                    setAttributes({ eventId: value });
                                },
                                help: __('Enter your ouRSVP event ID (found in your ouRSVP dashboard)', 'oursvp-event-rsvp-forms'),
                                placeholder: 'abc123xyz'
                            }),

                            // Link to get Event ID
                            el(
                                'p',
                                {
                                    key: 'event-id-link',
                                    style: {
                                        margin: '0 0 16px 0',
                                        fontSize: '12px'
                                    }
                                },
                                [
                                    el(
                                        'span',
                                        { key: 'text' },
                                        __("Don't have an Event ID? ", 'oursvp-event-rsvp-forms')
                                    ),
                                    el(
                                        'a',
                                        {
                                            key: 'link',
                                            href: 'https://www.oursvp.app/console',
                                            target: '_blank',
                                            rel: 'noopener noreferrer',
                                            style: {
                                                color: '#2271b1',
                                                textDecoration: 'underline'
                                            }
                                        },
                                        __('Create an event on ouRSVP →', 'oursvp-event-rsvp-forms')
                                    )
                                ]
                            ),

                            // Language selector
                            el(SelectControl, {
                                key: 'language',
                                label: __('Language', 'oursvp-event-rsvp-forms'),
                                value: language,
                                options: [
                                    { label: 'English', value: 'english' },
                                    { label: 'Spanish', value: 'spanish' }
                                ],
                                onChange: function (value) {
                                    setAttributes({ language: value });
                                }
                            }),

                            // Show Back Button toggle
                            el(ToggleControl, {
                                key: 'show-back-btn',
                                label: __('Show Back Button', 'oursvp-event-rsvp-forms'),
                                checked: showBackBtn,
                                onChange: function (value) {
                                    setAttributes({ showBackBtn: value });
                                },
                                help: __('Allow users to navigate back through form steps', 'oursvp-event-rsvp-forms')
                            }),

                            // Show Full Name toggle
                            el(ToggleControl, {
                                key: 'show-full-name',
                                label: __('Show Full Name', 'oursvp-event-rsvp-forms'),
                                checked: showFullName,
                                onChange: function (value) {
                                    setAttributes({ showFullName: value });
                                },
                                help: __('Display full names in the form', 'oursvp-event-rsvp-forms')
                            }),

                            // Limit Search toggle
                            el(ToggleControl, {
                                key: 'limit-search',
                                label: __('Limit Search', 'oursvp-event-rsvp-forms'),
                                checked: limitSearch,
                                onChange: function (value) {
                                    setAttributes({ limitSearch: value });
                                },
                                help: __('Restrict guest name search to 3x', 'oursvp-event-rsvp-forms')
                            })
                        ]
                    ),

                    // Custom Styling panel
                    el(
                        PanelBody,
                        {
                            title: __('Custom Styling', 'oursvp-event-rsvp-forms'),
                            initialOpen: false
                        },
                        [
                            el('p', { key: 'style-intro', style: { fontSize: '12px', marginBottom: '12px' } },
                                __('Override the default colors from your ouRSVP dashboard. Leave empty to use dashboard settings.', 'oursvp-event-rsvp-forms')
                            ),

                            // General Colors Section
                            el('div', { key: 'general-colors-section', style: { marginBottom: '20px' } }, [
                                el('h4', {
                                    key: 'general-colors-heading',
                                    style: {
                                        fontSize: '13px',
                                        fontWeight: '600',
                                        marginTop: '8px',
                                        marginBottom: '2px',
                                        color: '#1e1e1e',
                                        textTransform: 'uppercase',
                                        letterSpacing: '0.5px'
                                    }
                                }, __('Colors', 'oursvp-event-rsvp-forms')),
                                el('p', { key: 'general-colors-desc', style: { fontSize: '11px', marginTop: '0', marginBottom: '12px', color: '#757575' } },
                                    __('Form background, headings, and text', 'oursvp-event-rsvp-forms')
                                ),

                                // Background
                                el(BaseControl, {
                                    key: 'bg-color',
                                    label: __('Background Color', 'oursvp-event-rsvp-forms'),
                                    style: { marginBottom: '8px' },
                                    className: 'oursvp-tight-control'
                                }, [
                                    el(ColorPalette, {
                                        key: 'bg-color-picker',
                                        value: bgColor,
                                        onChange: function (value) {
                                            setAttributes({ bgColor: value || '' });
                                        },
                                        clearable: true,
                                        colors: [],
                                        disableCustomColors: false,
                                        __nextHasNoMarginBottom: true
                                    })
                                ]),

                                // Accent
                                el(BaseControl, {
                                    key: 'accent-color',
                                    className: 'oursvp-tight-control',
                                    label: __('Accent Color', 'oursvp-event-rsvp-forms'),
                                    style: { marginBottom: '8px' }
                                }, [
                                    el(ColorPalette, {
                                        key: 'accent-color-picker',
                                        value: accentColor,
                                        onChange: function (value) {
                                            setAttributes({ accentColor: value || '' });
                                        },
                                        clearable: true,
                                        colors: [],
                                        disableCustomColors: false
                                    })
                                ]),

                                // Heading
                                el(BaseControl, {
                                    key: 'heading-color',
                                    className: 'oursvp-tight-control',
                                    label: __('Heading Text', 'oursvp-event-rsvp-forms'),
                                    style: { marginBottom: '8px' }
                                }, [
                                    el(ColorPalette, {
                                        key: 'heading-color-picker',
                                        value: headingColor,
                                        onChange: function (value) {
                                            setAttributes({ headingColor: value || '' });
                                        },
                                        clearable: true,
                                        colors: [],
                                        disableCustomColors: false
                                    })
                                ]),

                                // Text
                                el(BaseControl, {
                                    key: 'text-color',
                                    className: 'oursvp-tight-control',
                                    label: __('Body Text', 'oursvp-event-rsvp-forms'),
                                    style: { marginBottom: '8px' }
                                }, [
                                    el(ColorPalette, {
                                        key: 'text-color-picker',
                                        value: textColor,
                                        onChange: function (value) {
                                            setAttributes({ textColor: value || '' });
                                        },
                                        clearable: true,
                                        colors: [],
                                        disableCustomColors: false
                                    })
                                ]),

                                // Date
                                el(BaseControl, {
                                    key: 'date-color',
                                    className: 'oursvp-tight-control',
                                    label: __('Date Text', 'oursvp-event-rsvp-forms'),
                                    style: { marginBottom: '8px' }
                                }, [
                                    el(ColorPalette, {
                                        key: 'date-color-picker',
                                        value: dateColor,
                                        onChange: function (value) {
                                            setAttributes({ dateColor: value || '' });
                                        },
                                        clearable: true,
                                        colors: [],
                                        disableCustomColors: false
                                    })
                                ])
                                
                            ]),

                            // Button Styling Section
                            el('div', { key: 'button-section', style: { marginBottom: '16px' } }, [
                                el('h4', {
                                    key: 'button-heading',
                                    style: {
                                        fontSize: '13px',
                                        fontWeight: '600',
                                        marginTop: '8px',
                                        marginBottom: '2px',
                                        color: '#1e1e1e',
                                        textTransform: 'uppercase',
                                        letterSpacing: '0.5px'
                                    }
                                }, __('Buttons', 'oursvp-event-rsvp-forms')),
                                el('p', { key: 'button-desc', style: { fontSize: '11px', marginTop: '0', marginBottom: '12px', color: '#757575' } },
                                    __('Button colors, border, and shape', 'oursvp-event-rsvp-forms')
                                ),

                                // Button Background
                                el(BaseControl, {
                                    key: 'button-bg-color',
                                    className: 'oursvp-tight-control',
                                    label: __('Background', 'oursvp-event-rsvp-forms'),
                                    style: { marginBottom: '8px' }
                                }, [
                                    el(ColorPalette, {
                                        key: 'button-bg-color-picker',
                                        value: buttonBgColor,
                                        onChange: function (value) {
                                            setAttributes({ buttonBgColor: value || '' });
                                        },
                                        clearable: true,
                                        colors: [],
                                        disableCustomColors: false
                                    })
                                ]),

                                // Button Text
                                el(BaseControl, {
                                    key: 'button-text-color',
                                    className: 'oursvp-tight-control',
                                    label: __('Text', 'oursvp-event-rsvp-forms'),
                                    style: { marginBottom: '8px' }
                                }, [
                                    el(ColorPalette, {
                                        key: 'button-text-color-picker',
                                        value: buttonTextColor,
                                        onChange: function (value) {
                                            setAttributes({ buttonTextColor: value || '' });
                                        },
                                        clearable: true,
                                        colors: [],
                                        disableCustomColors: false
                                    })
                                ]),

                                // Button Border Color
                                el(BaseControl, {
                                    key: 'button-border-color',
                                    className: 'oursvp-tight-control',
                                    label: __('Border color', 'oursvp-event-rsvp-forms'),
                                    style: { marginBottom: '8px' }
                                }, [
                                    el(ColorPalette, {
                                        key: 'button-border-color-picker',
                                        value: buttonBorderColor,
                                        onChange: function (value) {
                                            setAttributes({ buttonBorderColor: value || '' });
                                        },
                                        clearable: true,
                                        colors: [],
                                        disableCustomColors: false
                                    })
                                ]),

                                // Border Width
                                el(TextControl, {
                                    key: 'button-border-width',
                                    label: __('Border width', 'oursvp-event-rsvp-forms'),
                                    value: buttonBorderWidth,
                                    onChange: function (value) {
                                        setAttributes({ buttonBorderWidth: value });
                                    },
                                    placeholder: '1px',
                                    style: { marginBottom: '8px' }
                                }),

                                // Border Radius
                                el(TextControl, {
                                    key: 'button-border-radius',
                                    label: __('Border radius', 'oursvp-event-rsvp-forms'),
                                    value: buttonBorderRadius,
                                    onChange: function (value) {
                                        setAttributes({ buttonBorderRadius: value });
                                    },
                                    placeholder: '8px'
                                })
                            ]),

                            // CSS Classes Footnote
                            el('p', {
                                key: 'css-footnote',
                                style: {
                                    fontSize: '12px',
                                    marginTop: '36px',
                                    padding: '12px',
                                    backgroundColor: '#f0f0f1',
                                    borderRadius: '4px',
                                    lineHeight: '1.5',
                                    color: '#50575e'
                                }
                            }, __('You can also style the form with more control by adding new styles to your CSS file, each section has a specific class name (ex: .rsvp-survey, .rsvp-font, .rsvp-title, .rsvp-btn)', 'oursvp-event-rsvp-forms'))
                        ]
                    ),

                    // Help panel
                    el(
                        PanelBody,
                        {
                            title: __('Need Help?', 'oursvp-event-rsvp-forms'),
                            initialOpen: false
                        },
                        el(
                            'div',
                            { style: { lineHeight: '1.6' } },
                            [
                                el('p', { key: 'help-1' }, __('To get your Event ID:', 'oursvp-event-rsvp-forms')),
                                el('ol', { key: 'help-list', style: { marginLeft: '1.5em' } }, [
                                    el('li', { key: 'step-1' }, __('Log in to ouRSVP.app', 'oursvp-event-rsvp-forms')),
                                    el('li', { key: 'step-2' }, __('Go to your event dashboard', 'oursvp-event-rsvp-forms')),
                                    el('li', { key: 'step-3' }, __('Copy your Event ID', 'oursvp-event-rsvp-forms'))
                                ]),
                                el(
                                    'p',
                                    { key: 'help-2', style: { marginTop: '1em' } },
                                    el(
                                        'a',
                                        {
                                            href: 'https://www.oursvp.app/console',
                                            target: '_blank',
                                            rel: 'noopener noreferrer',
                                            style: { color: '#2271b1', textDecoration: 'underline' }
                                        },
                                        __('Open ouRSVP Dashboard →', 'oursvp-event-rsvp-forms')
                                    )
                                )
                            ]
                        )
                    )
                ),

                // Block preview in editor
                el(
                    'div',
                    Object.assign(
                        {},
                        blockEditor.useBlockProps({
                            className: 'oursvp-block-preview',
                            style: {
                                padding: '3rem 2rem',
                                border: '2px dashed #cbd5e0',
                                borderRadius: '8px',
                                textAlign: 'center',
                                backgroundColor: '#f7fafc',
                                minHeight: '300px',
                                display: 'flex',
                                flexDirection: 'column',
                                alignItems: 'center',
                                justifyContent: 'center'
                            }
                        }),
                        { key: 'preview' }
                    ),
                    [
                        // Icon
                        el(
                            'div',
                            {
                                key: 'icon',
                                style: {
                                    fontSize: '3rem',
                                    marginBottom: '1rem'
                                }
                            },
                            '📋'
                        ),

                        // Title
                        el(
                            'h3',
                            {
                                key: 'title',
                                style: {
                                    fontSize: '1.5rem',
                                    fontWeight: '600',
                                    margin: '0 0 0.5rem 0',
                                    color: '#1a202c'
                                }
                            },
                            __('ouRSVP Form', 'oursvp-event-rsvp-forms')
                        ),

                        // Event ID display or warning
                        eventId
                            ? el(
                                  'div',
                                  { key: 'event-info' },
                                  [
                                      el(
                                          'p',
                                          {
                                              key: 'event-id',
                                              style: {
                                                  margin: '0.5rem 0 0',
                                                  color: '#4a5568',
                                                  fontFamily: 'monospace',
                                                  fontSize: '0.95rem'
                                              }
                                          },
                                          __('Event ID: ', 'oursvp-event-rsvp-forms') + eventId
                                      ),
                                      el(
                                          'p',
                                          {
                                              key: 'language-info',
                                              style: {
                                                  margin: '0.25rem 0 0',
                                                  color: '#718096',
                                                  fontSize: '0.875rem'
                                              }
                                          },
                                          __('Language: ', 'oursvp-event-rsvp-forms') + language.charAt(0).toUpperCase() + language.slice(1)
                                      ),
                                      el(
                                          'p',
                                          {
                                              key: 'preview-note',
                                              style: {
                                                  margin: '1rem 0 0',
                                                  padding: '0.75rem 1rem',
                                                  backgroundColor: '#edf2f7',
                                                  borderRadius: '4px',
                                                  color: '#4a5568',
                                                  fontSize: '0.875rem'
                                              }
                                          },
                                          __('The form will appear here on your published page', 'oursvp-event-rsvp-forms')
                                      )
                                  ]
                              )
                            : el(
                                  'p',
                                  {
                                      key: 'warning',
                                      style: {
                                          margin: '0.5rem 0 0',
                                          padding: '0.75rem 1rem',
                                          backgroundColor: '#fed7d7',
                                          color: '#742a2a',
                                          borderRadius: '4px',
                                          fontSize: '0.875rem',
                                          fontWeight: '500'
                                      }
                                  },
                                  '⚠️ ' + __('Please enter an Event ID in the sidebar settings →', 'oursvp-event-rsvp-forms')
                              )
                    ]
                )
            ];
        },

        /**
         * Save function - return null for dynamic rendering
         */
        save: function () {
            // Return null to use PHP render_callback for dynamic rendering
            // This ensures the form always loads fresh data from ouRSVP API
            return null;
        }
    });
})(
    window.wp.blocks,
    window.wp.element,
    window.wp.components,
    window.wp.blockEditor,
    window.wp.i18n
);
