<?php
if (!defined('ABSPATH')) exit; // Exit if accessed directly

// Step 1: Register scripts & styles
add_action('wp_enqueue_scripts', 'orufy_booking_register_assets', 1);
function orufy_booking_register_assets()
{
    wp_register_style(
        'orufy-booking-widget-style',
        'https://orufybookings.com/external/widget.css',
        [],
        null
    );

    wp_register_script(
        'orufy-booking-widget-script',
        'https://orufybookings.com/external/widget.js',
        [],
        null,
        true
    );
}

// Step 2: Detect shortcodes in page content
add_action('the_posts', 'orufy_booking_check_shortcodes');
function orufy_booking_check_shortcodes($posts)
{
    if (empty($posts)) {
        return $posts;
    }

    $shortcodes = ['orufy-booking-inline', 'orufy-booking-popup-widget', 'orufy-booking-popup-text'];

    foreach ($posts as $post) {
        foreach ($shortcodes as $shortcode) {
            if (has_shortcode($post->post_content, $shortcode)) {
                add_action('wp_enqueue_scripts', 'orufy_booking_enqueue_assets');
                return $posts;
            }
        }
    }

    return $posts;
}

// Step 3: Enqueue styles/scripts if needed
function orufy_booking_enqueue_assets()
{
    wp_enqueue_style('orufy-booking-widget-style');
    wp_enqueue_script('orufy-booking-widget-script');
}

// Step 4: Helper to add inline script safely
function orufy_booking_maybe_add_inline_script($script)
{
    if (wp_script_is('orufy-booking-widget-script', 'enqueued')) {
        wp_add_inline_script('orufy-booking-widget-script', $script);
    }
}

// Shortcode: Inline Widget
add_shortcode('orufy-booking-inline', 'fun_orufy_booking_inline');
function fun_orufy_booking_inline()
{
    $event      = get_option('orufy_selected_event_data', []);
    $slug       = isset($event['slug']) ? sanitize_text_field($event['slug']) : '';
    $accessLink = isset($event['accessLink']) ? sanitize_text_field($event['accessLink']) : '';
    $access_url = '/' . rawurlencode($accessLink) . '/' . rawurlencode($slug) . '?BackgroundColor=FFFFFF&BrandColor=098666&hideLHS=false';

    $script = 'window.addEventListener("load", function () {
        if (typeof orufyBookings !== "undefined" && typeof orufyBookings.InLineWidget === "function") {
            orufyBookings.InLineWidget();
        }
    });';
    orufy_booking_maybe_add_inline_script($script);

    return '<div style="height:100dvh" class="orufy-bookings-inline-widget" data-access-link="' . esc_attr($access_url) . '"></div>';
}

// Shortcode: Popup Widget Button
add_shortcode('orufy-booking-popup-widget', 'fun_orufy_booking_popup_widget');
function fun_orufy_booking_popup_widget()
{
    $event      = get_option('orufy_selected_event_data', []);
    $slug       = isset($event['slug']) ? sanitize_text_field($event['slug']) : '';
    $accessLink = isset($event['accessLink']) ? sanitize_text_field($event['accessLink']) : '';
    $access_url = '/' . rawurlencode($accessLink) . '/' . rawurlencode($slug) . '?BrandColor=098666&hideLHS=false&BackgroundColor=transparent';

    $script = 'window.addEventListener("load", function () {
        if (typeof orufyBookings !== "undefined" && typeof orufyBookings.PopupWidget === "function") {
            orufyBookings.PopupWidget({
                AccessLink: "' . esc_js($access_url) . '",
                ButtonBackground: "098666",
                ButtonText: "' . esc_js(__('Book an event', 'orufy-bookings')) . '",
                ButtonTextColor: "FFFFFF"
            });
        }
    });';
    orufy_booking_maybe_add_inline_script($script);

    return ''; // No markup needed
}

// Shortcode: Popup Text Link
add_shortcode('orufy-booking-popup-text', 'fun_orufy_booking_popup_text');
function fun_orufy_booking_popup_text()
{
    $event      = get_option('orufy_selected_event_data', []);
    $slug       = isset($event['slug']) ? sanitize_text_field($event['slug']) : '';
    $accessLink = isset($event['accessLink']) ? sanitize_text_field($event['accessLink']) : '';
    $access_url = '/' . rawurlencode($accessLink) . '/' . rawurlencode($slug) . '?BrandColor=098666&hideLHS=false&BackgroundColor=transparent';

    $html = '<a href="#" onclick="if(typeof orufyBookings !== \'undefined\'){orufyBookings.PopUpLink({ AccessLink: \'' . esc_js($access_url) . '\' });} return false;">'
        . esc_html__('Book an event', 'orufy-bookings') . '</a>';

    return $html;
}
