<?php
if (! defined('ABSPATH')) exit; // Exit if accessed directly
if (! defined('ORUFY_BOOKING_API_BASE_URL')) {
    define('ORUFY_BOOKING_API_BASE_URL', 'https://bookings.orufy.com');
}

function orufy_booking_save_settings()
{
    if (! current_user_can('manage_options') || ! check_admin_referer('orufy_booking_save_settings')) {
        wp_die('Permission denied or invalid nonce.');
    }

    $api_key    = isset($_POST['orufy_api_key']) ? sanitize_text_field(wp_unslash($_POST['orufy_api_key'])) : '';
    $api_secret = isset($_POST['orufy_api_secret']) ? sanitize_text_field(wp_unslash($_POST['orufy_api_secret'])) : '';

    // Compare old API credentials
    $old_key    = get_option('orufy_api_key');
    $old_secret = get_option('orufy_api_secret');

    if ($api_key !== $old_key || $api_secret !== $old_secret) {
        delete_option('orufy_selected_event_data');
        delete_transient('orufy_booking_last_api_response');
    }

    update_option('orufy_api_key', $api_key);
    update_option('orufy_api_secret', $api_secret);

    // Call API quickly to test
    $response = wp_remote_get(ORUFY_BOOKING_API_BASE_URL . '/api/v1/bookings/api/event', [
        'headers' => [
            'x-api-key'    => $api_key,
            'x-api-secret' => $api_secret,
        ],
        'timeout' => 10,
    ]);

    if (is_wp_error($response)) {
        $result = 'API Request Failed: ' . $response->get_error_message();
    } else {
        $body = wp_remote_retrieve_body($response);
        $json = json_decode($body, true);

        if (! empty($json['isSuccess']) && ! empty($json['events'])) {
            $events = array_filter($json['events'], fn($e) => ! empty($e['name']));
            set_transient('orufy_booking_last_api_response', $json, 60 * 60);
            $result = 'Successfully connected. Please select an event.';
        } else {
            $result = 'No events found or invalid response.';
        }
    }

    set_transient('orufy_booking_api_result', $result, 60);
    wp_safe_redirect(admin_url('admin.php?page=' . ORUFY_BOOKING_ADMIN_SLUG));
    exit;
}
add_action('admin_post_orufy_booking_save_settings', 'orufy_booking_save_settings');


add_action('admin_post_orufy_booking_select_event', 'orufy_booking_select_event');
function orufy_booking_select_event()
{
    if (! current_user_can('manage_options') || ! check_admin_referer('orufy_booking_select_event')) {
        wp_die('Permission denied or invalid nonce.');
    }

    $selected_event = isset($_POST['orufy_selected_event']) ? sanitize_text_field(wp_unslash($_POST['orufy_selected_event'])) : '';

    $last_api_response = get_transient('orufy_booking_last_api_response');
    $events = is_array($last_api_response['events'] ?? null) ? $last_api_response['events'] : [];

    $event_data_to_save = [
        'id'         => $selected_event,
        'slug'       => '',
        'accessLink' => '',
    ];

    if (! empty($events)) {
        foreach ($events as $event) {
            if (($event['_id'] ?? '') === $selected_event) {
                $event_data_to_save['slug'] = sanitize_text_field($event['slug'] ?? '');

                if (! empty($event['teamId']) && ! empty($event['accessLink'])) {
                    $event_data_to_save['accessLink'] = sanitize_text_field($event['accessLink']);
                } else {
                    $event_data_to_save['accessLink'] = sanitize_text_field($last_api_response['appInfo']['accessLink'] ?? '');
                }
                break;
            }
        }
    }

    update_option('orufy_selected_event_data', $event_data_to_save);

    wp_safe_redirect(admin_url('admin.php?page=' . ORUFY_BOOKING_ADMIN_SLUG));
    exit;
}
