<?php
if (! defined('ABSPATH')) exit; // Exit if accessed directly

// constants for reuse
if (! defined('ORUFY_BOOKING_ADMIN_SLUG')) {
    define('ORUFY_BOOKING_ADMIN_SLUG', 'orufy_booking_settings'); // used by add_menu_page
}

add_action('admin_menu', 'orufy_booking_admin_menu');
add_action('admin_enqueue_scripts', 'orufy_booking_admin_assets');

function orufy_booking_admin_menu()
{
    add_menu_page(
        'Orufy Booking',
        'Orufy Booking',
        'manage_options',
        ORUFY_BOOKING_ADMIN_SLUG,
        'orufy_booking_settings_page',
        plugins_url('assets/book.svg', __FILE__),
        56
    );
}

function orufy_booking_admin_assets($hook_suffix)
{
    // Only load on our plugin admin page
    // For top-level pages WP constructs hook as 'toplevel_page_{menu_slug}'
    $our_hook = 'toplevel_page_' . ORUFY_BOOKING_ADMIN_SLUG;
    if ($hook_suffix !== $our_hook) {
        return;
    }

    $base = plugin_dir_url(__FILE__);

    wp_register_style(
        'orufy-booking-admin-css',
        $base . 'assets/css/admin.css',
        [],
        null
    );

    wp_enqueue_style('orufy-booking-admin-css');

    // If you need JS later, register and enqueue here similarly:
    // wp_register_script('orufy-booking-admin-js', $base . 'assets/js/admin.js', ['jquery'], null, true);
    // wp_enqueue_script('orufy-booking-admin-js');
}

function orufy_booking_settings_page()
{
    // Markup wrapper/class added to namespace CSS
    echo '<div class="orufy-booking-admin">';

    include __DIR__ . '/views/settings.php';

    // Show API result if available
    if ($result = get_transient('orufy_booking_api_result')) {
        echo '<div class="notice notice-info"><p>' . esc_html($result) . '</p></div>';
        delete_transient('orufy_booking_api_result');
    }

    echo '</div>'; // .orufy-booking-admin
}
