=== Orufy Bookings ===
Contributors: vikashoru
Tags: booking, event booking, widget shortcode, orufy, calendar
Requires at least: 1.0
Tested up to: 6.8
Stable tag: 1.0.0
License: GPLv2 or later

Seamlessly integrate Orufy booking widgets into your WordPress site. Manage API credentials, select events, and embed booking widgets or popups using simple shortcodes.

== Description ==
Orufy Bookings empowers your WordPress site with:

- A modern event booking widget, embeddable anywhere via shortcode.
- Admin settings to securely connect your Orufy account and select events.
- Multiple display options: inline widget, popup button, or popup text link.

= Key Features: =

1. **Event Booking Widget via Shortcode**  
   Add a sleek, interactive event booking widget to your site using the provided shortcodes.

   - Place the shortcode on any page, post, or widget area.
   - The widget connects to your Orufy account (requires API Key & Secret configuration in settings).

2. **Admin-Friendly Configuration**

   - Simple settings page for API credentials and event selection.
   - Secure storage of API keys and event data.
   - Fetch and select active events from your Orufy account.

3. **Flexible Display Options**

   - **Inline Widget:** `[orufy-booking-inline]` — Embed the booking widget directly in your content.
   - **Popup Widget Button:** `[orufy-booking-popup-widget]` — Add a floating button that opens the booking popup.
   - **Popup Text Link:** `[orufy-booking-popup-text]` — Add a text link that opens the booking popup.

4. **Automatic Asset Loading**
   - Loads Orufy widget CSS and JS only when shortcodes are present on the page.

= Before You Begin =

Before using the Orufy Bookings WordPress plugin, please review the official Orufy documentation for setting up your Orufy account and events:

- **Orufy Bookings Setup Guide:** [https://orufy.com/support/bookings](https://orufy.com/support/bookings)

This guide will help you configure your Orufy account, obtain API credentials, and set up events for seamless integration with your WordPress site.

= External Services =

This plugin connects to Orufy's cloud services to enable event booking functionality. Here's what you need to know about external service usage:

**Orufy Booking Widget Service**

- **Purpose:** Powers the interactive event booking widget on your website
- **Data Transmitted:**
  - Booking form submissions and interactions
  - Website visitor metadata (IP address, browser info, page URL)
  - Booking session data and timestamps
- **When:** Data is sent when visitors interact with the booking widget
- **Service Provider:** Orufy Technologies Inc.
- **Legal:** [Orufy Terms of Service](https://orufy.com/terms) | [Privacy Policy](https://orufy.com/privacy-policy)

**Orufy CDN Assets**

To ensure fast and consistent widget performance, this plugin loads JavaScript and CSS files from the official Orufy CDN:

- **Loaded Files:**
  - `https://orufybookings.com/external/widget.js`
  - `https://orufybookings.com/external/widget.css`
- **Purpose:** These files power and style the Orufy booking widgets embedded on your site.
- **When:** These assets are only loaded on frontend pages where the plugin shortcodes (`[orufy-booking-inline]`, `[orufy-booking-popup-widget]`, or `[orufy-booking-popup-text]`) are present.
- **Host:** CDN is served securely via HTTPS from [orufybookings.com](https://orufybookings.com).

_Note: All data is transmitted securely via HTTPS and processed in accordance with Orufy's privacy policy and terms of service._

= Installation =

== From your WordPress dashboard ==

1. Visit `Plugins > Add New`.
2. Search for `Orufy Bookings`. Install and activate the plugin.

== From WordPress.org ==

1. Download the Orufy Bookings plugin.
2. Unzip and upload the `orufy-booking` directory to your `/wp-content/plugins/` directory.
3. Activate Orufy Bookings from your Plugins page.

= Usage =

**Before Configuration:**

1. Create an Orufy account at [https://orufy.com/register?redirect=BOOKINGS](https://orufy.com/register?redirect=BOOKINGS)
2. Login to your Orufy dashboard at [https://orufy.com/login?redirect=BOOKINGS](https://orufy.com/login?redirect=BOOKINGS)

**To add the booking widget:**

1. Go to `Orufy Booking` settings in the admin menu.
2. Enter your Orufy API Key and Secret (see the Bookings Setup Guide above).
3. Click **Save and Connect** to fetch your events.
4. Select an active event and save your selection.
5. Use one of the following shortcodes anywhere on your site:
   - `[orufy-booking-inline]` — Inline booking widget
   - `[orufy-booking-popup-widget]` — Popup booking button
   - `[orufy-booking-popup-text]` — Popup booking text link

> **Note:** Shortcodes will only work after you have selected an event in the plugin settings.

= Frequently Asked Questions =

**Q: How do I get my Orufy API Key and Secret?**  
A: Follow the Bookings Setup Guide: [https://orufy.com/support/bookings](https://orufy.com/support/bookings)

**Q: Why don’t the shortcodes work?**  
A: Make sure you have entered valid API credentials and selected an event in the settings.

**Q: Are assets loaded on every page?**  
A: No, widget CSS/JS are only loaded if a supported shortcode is present on the page.

= Contact Us =  
Need help or have questions? Email us at support@orufy.com.

= Website =  
Learn more at [https://orufy.com/bookings](https://orufy.com/bookings).
Visit at [https://bookings.orufy.com](https://bookings.orufy.com).

= Legal =

- Privacy Policy: [https://orufy.com/privacy-policy](https://orufy.com/privacy-policy)
- Terms of Service: [https://orufy.com/terms](https://orufy.com/terms)

== Changelog ==
= 1.0.0 =

- Initial release: Event booking widget shortcodes and admin event selection.
