<?php
/**
 * Fired when the plugin is uninstalled.
 *
 * @package Orphanix Media Cleanup
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

// Check if user enabled "Delete Plugin Data" option
$orphanix_delete_on_uninstall = get_option('orphanix_delete_on_uninstall', false);

// Only delete data if the option is enabled
if ( $orphanix_delete_on_uninstall ) {
    global $wpdb;

    // Clean up custom tables
    // phpcs:disable WordPress.DB.DirectDatabaseQuery.SchemaChange, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.InterpolatedNotPrepared
    $wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}orphanix_scans");
    $wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}orphanix_scan_items");
    $wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}orphanix_live_scan_details");
    $wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}orphanix_trash");
    $wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}orphanix_audit_log");
    // phpcs:enable WordPress.DB.DirectDatabaseQuery.SchemaChange, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.InterpolatedNotPrepared

    // Remove options
    delete_option('orphanix_settings');
    delete_option('orphanix_scan_compat');
    delete_option('orphanix_delete_on_uninstall');
    delete_option('orphanix_last_live_scan_at');
    delete_option('orphanix_last_live_scan_status');
    delete_option('orphanix_last_live_scan_mode');
    delete_option('orphanix_db_migrated');
    delete_option('orphanix_db_version');

    // Remove orphanix option rows and transients.
    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
    $wpdb->query(
        "DELETE FROM {$wpdb->options} WHERE option_name LIKE 'orphanix_%'"
    );
    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
    $wpdb->query(
        "DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_orphanix_%' OR option_name LIKE '_transient_timeout_orphanix_%'"
    );
}


