<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class ORPHANIX_Paths {

	public static function base_upload_dir_path(): string {
		$upload_dir = wp_upload_dir();
		$base       = trailingslashit( $upload_dir['basedir'] ) . 'orphanix-media-cleanup/';

		// Ensure directory exists.
		if ( ! file_exists( $base ) ) {
			wp_mkdir_p( $base );
		}

		return $base;
	}

	public static function base_upload_dir_url(): string {
		$upload_dir = wp_upload_dir();
		return trailingslashit( $upload_dir['baseurl'] ) . 'orphanix-media-cleanup/';
	}

	public static function ensure_subdir( string $subdir ): string {
		$path = trailingslashit( self::base_upload_dir_path() ) . trim( $subdir, "/\\" ) . '/';
		if ( ! file_exists( $path ) ) {
			wp_mkdir_p( $path );
		}
		return $path;
	}
}
