<?php
class ORPHANIX_Helpers {
    public static function format_bytes($bytes, $precision = 2) {
        $units = ['B', 'KB', 'MB', 'GB', 'TB'];
        $bytes = max($bytes, 0);
        $pow = floor(($bytes ? log($bytes) : 0) / log(1024));
        $pow = min($pow, count($units) - 1);
        $bytes /= pow(1024, $pow);
        return round($bytes, $precision) . ' ' . $units[$pow];
    }

    public static function safe_array($value) {
        return is_array($value) ? $value : [];
    }

    public static function esc_array($array) {
        return array_map('esc_html', $array);
    }
}
