<?php
class ORPHANIX_Formatter {
    public static function status_label($status) {
        switch ($status) {
            case 'used':
                return '<span data-orphanix-style="orphanix-s-0159">'.__('Used','orphanix-media-cleanup').'</span>';
            case 'orphan':
                return '<span data-orphanix-style="orphanix-s-0160">'.__('Orphan','orphanix-media-cleanup').'</span>';
            case 'broken':
                return '<span data-orphanix-style="orphanix-s-0161">'.__('Broken','orphanix-media-cleanup').'</span>';
            default:
                return esc_html($status);
        }
    }

    public static function date_label($date) {
        return date_i18n(get_option('date_format').' '.get_option('time_format'), strtotime($date));
    }
}
