<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( ! class_exists( 'WP_List_Table' ) ) {
    require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
}

class ORPHANIX_Scans_Table extends WP_List_Table {
    public function __construct() {
        parent::__construct([
            'singular' => 'scan',
            'plural'   => 'scans',
            'ajax'     => false,
        ]);
    }

    public function get_columns() {
        return [
            'scan_mode'   => __('Type','orphanix-media-cleanup'),
            'started_at'  => __('Date','orphanix-media-cleanup'),
            'status'      => __('Status','orphanix-media-cleanup'),
            'results'     => __('Results','orphanix-media-cleanup'),
            'actions'     => __('Actions','orphanix-media-cleanup'),
        ];
    }

    public function prepare_items() {
        $repo = new ORPHANIX_Scan_Repository();
        $this->items = $repo->all_scans();
        $this->_column_headers = [$this->get_columns(), [], []];
    }

    public function column_default($item, $column_name) {
        switch ($column_name) {
            case 'scan_mode':
            case 'started_at':
            case 'status':
                return esc_html($item[$column_name]);
            case 'results':
                return sprintf(
                    /* translators: 1: processed count, 2: used count, 3: orphan count. */
                    esc_html__( 'Processed: %1$d | Used: %2$d | Orphan: %3$d', 'orphanix-media-cleanup' ),
                    $item['processed_files'],
                    $item['used_files'],
                    $item['orphan_files']
                );
            case 'actions':
                $view_url = admin_url('admin.php?page=orphanix-results&scan='.$item['id']);
                $delete_url = wp_nonce_url(admin_url('admin.php?page=orphanix-dashboard&delete_scan='.$item['id']), 'orphanix_delete_scan');
                return sprintf('<a href="%s">%s</a> | <a href="%s">%s</a>',
                    esc_url($view_url),
                    esc_html__( 'View', 'orphanix-media-cleanup' ),
                    esc_url($delete_url),
                    esc_html__( 'Delete', 'orphanix-media-cleanup' )
                );
            default:
                return '&ndash;';
        }
    }
}
