<?php
class ORPHANIX_Nonce {
    public static function create($action) {
        return wp_create_nonce($action);
    }

    public static function verify($action, $field = 'nonce') {
        if ( ! isset($_POST[$field]) ) {
            return false;
        }
        $nonce = sanitize_text_field( wp_unslash( $_POST[$field] ) );
        return wp_verify_nonce( $nonce, $action );
    }

    public static function check_ajax($action, $field = 'nonce') {
        check_ajax_referer($action, $field);
    }
}
