<?php
class ORPHANIX_Scan_Manager {
    public function start_scan($type = 'regular', $mode = 'media', $settings = []) {
        global $wpdb;

        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
        $wpdb->insert("{$wpdb->prefix}orphanix_scans", [
            'scan_type'   => $mode,
            'scan_mode'   => $type,
            'status'      => 'running',
            'settings'    => wp_json_encode($settings),
            'started_at'  => current_time('mysql'),
            'created_by'  => get_current_user_id(),
        ]);

        $scan_id = $wpdb->insert_id;

        if ( class_exists( 'ORPHANIX_Logger' ) ) {
            ORPHANIX_Logger::log(
                'Scan started',
                [
                    'scan_id' => $scan_id,
                    'scan_type' => $mode,
                    'scan_mode' => $type,
                    'user_id' => get_current_user_id()
                ]
            );
        }

        return $scan_id;
    }

    public function complete_scan($scan_id, $stats) {
        global $wpdb;
        
        // Get current scan data to check if total_files is set
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
        $scan = $wpdb->get_row($wpdb->prepare("SELECT total_files FROM {$wpdb->prefix}orphanix_scans WHERE id = %d", $scan_id));
        
        $update_data = [
            'status'       => 'completed',
            'processed_files' => $stats['processed'],
            'used_files'   => $stats['used'],
            'orphan_files' => $stats['orphan'],
            'completed_at' => current_time('mysql'),
        ];
        
        // Only set total_files if not already set
        if (!$scan->total_files) {
            $update_data['total_files'] = $stats['processed'];
        }
        
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
        $wpdb->update("{$wpdb->prefix}orphanix_scans", $update_data, ['id' => $scan_id]);

        if ( class_exists( 'ORPHANIX_Logger' ) ) {
            ORPHANIX_Logger::log(
                'Scan completed',
                [
                    'scan_id' => $scan_id,
                    'processed' => $stats['processed'] ?? 0,
                    'used' => $stats['used'] ?? 0,
                    'orphan' => $stats['orphan'] ?? 0
                ]
            );
        }
    }

    public function add_item($scan_id, $item) {
        global $wpdb;
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
        $wpdb->insert("{$wpdb->prefix}orphanix_scan_items", [
            'scan_id'       => $scan_id,
            'attachment_id' => $item['attachment_id'] ?? null,
            'file_path'     => $item['file_path'],
            'file_url'      => $item['file_url'] ?? null,
            'file_size'     => $item['file_size'] ?? 0,
            'alt_text'      => $item['alt_text'] ?? '',
            'directory_type'=> $item['directory_type'],
            'usage_context' => wp_json_encode($item['usage_context'] ?? []),
            'status'        => $item['status'],
            'created_at'    => current_time('mysql'),
        ]);
    }
}

