<?php
/**
 * Usage Detector Interface
 * 
 * All detectors must implement this interface to be compatible
 * with the unified detection engine.
 */

interface ORPHANIX_Usage_Detector {
    /**
     * Detect if media is used
     * 
     * @param int $attachment_id WordPress attachment ID (if applicable)
     * @param string $file_url Full URL or path to the file
     * @return array {
     *     @type bool $used Whether the media is used
     *     @type array $used_by Array of post IDs where media is found
     *     @type string $source Detection source identifier
     * }
     */
    public function detect( $attachment_id, $file_url );

    /**
     * Get detector name
     * 
     * @return string Detector name for logging
     */
    public function get_name();

    /**
     * Check if detector is available
     * 
     * @return bool True if required plugin/feature is available
     */
    public function is_available();
}
