<?php
/**
 * WooCommerce Detector
 * 
 * Detects media in WooCommerce products
 * Performance: Fast (product meta queries)
 */

class ORPHANIX_WooCommerce_Detector implements ORPHANIX_Usage_Detector {
    
    public function detect( $attachment_id, $file_url ) {
        global $wpdb;

        if ( ! $this->is_available() || ! $attachment_id ) {
            return [
                'used' => false,
                'used_by' => [],
                'source' => 'woocommerce'
            ];
        }

        // Check product galleries
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
        $results = $wpdb->get_col( $wpdb->prepare(
            "SELECT post_id FROM {$wpdb->postmeta} 
             WHERE meta_key = '_product_image_gallery' 
             AND meta_value LIKE %s",
            '%' . $attachment_id . '%'
        ));

        return [
            'used' => ! empty( $results ),
            'used_by' => $results,
            'source' => 'woocommerce'
        ];
    }

    public function get_name() {
        return 'WooCommerce Detector';
    }

    public function is_available() {
        return function_exists( 'WC' ) || class_exists( 'WooCommerce' );
    }
}
