<?php
/**
 * Widget Detector
 * 
 * Detects media in WordPress widgets
 * Performance: Fast (option table scan)
 */

class ORPHANIX_Widget_Detector implements ORPHANIX_Usage_Detector {
    
    public function detect( $attachment_id, $file_url ) {
        if ( ! $attachment_id ) {
            return [
                'used' => false,
                'used_by' => [],
                'source' => 'widget'
            ];
        }

        // Check media widgets
        $widgets = [
            get_option( 'widget_media_image', [] ),
            get_option( 'widget_media_gallery', [] ),
        ];

        foreach ( $widgets as $widget_data ) {
            if ( ! is_array( $widget_data ) ) continue;
            
            foreach ( $widget_data as $instance ) {
                if ( isset( $instance['attachment_id'] ) && intval( $instance['attachment_id'] ) === intval( $attachment_id ) ) {
                    return [
                        'used' => true,
                        'used_by' => [],
                        'source' => 'widget'
                    ];
                }
            }
        }

        return [
            'used' => false,
            'used_by' => [],
            'source' => 'widget'
        ];
    }

    public function get_name() {
        return 'Widget Detector';
    }

    public function is_available() {
        return true;
    }
}
