<?php
/**
 * Theme File Detector (Deep Scan Only)
 * 
 * Scans active theme files for media references
 * Performance: Slow (filesystem scan)
 */

class ORPHANIX_Theme_File_Detector implements ORPHANIX_Usage_Detector {
    
    public function detect( $attachment_id, $file_url ) {
        $filename = basename( $file_url );
        $theme_dir = get_template_directory();
        
        // Search theme files
        $extensions = ['php', 'css', 'js'];
        $found = false;

        foreach ( $extensions as $ext ) {
            $files = glob( $theme_dir . '/**/*.' . $ext, GLOB_BRACE );
            
            foreach ( $files as $file ) {
                if ( ! is_readable( $file ) ) continue;
                
                $content = file_get_contents( $file );
                if ( strpos( $content, $filename ) !== false ) {
                    $found = true;
                    break 2;
                }
            }
        }

        return [
            'used' => $found,
            'used_by' => [],
            'source' => 'theme_file'
        ];
    }

    public function get_name() {
        return 'Theme File Detector';
    }

    public function is_available() {
        return true;
    }
}
