<?php
/**
 * Custom Fields (Meta) Detector
 * 
 * Detects media in wp_postmeta (serialization-safe)
 * Performance: Medium (wildcard search)
 */

class ORPHANIX_Meta_Detector implements ORPHANIX_Usage_Detector {
    
    public function detect( $attachment_id, $file_url ) {
        global $wpdb;

        $used_by = [];
        $filename = basename( $file_url );
        
        // Search for both ID and filename in meta values
        $patterns = [
            '%' . $wpdb->esc_like( $filename ) . '%',
        ];

        if ( $attachment_id ) {
            $patterns[] = '%i:' . intval( $attachment_id ) . ';%'; // Serialized integer
            $patterns[] = '%"' . intval( $attachment_id ) . '"%';  // JSON/quoted
        }

        foreach ( $patterns as $pattern ) {
            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
            $results = $wpdb->get_col( $wpdb->prepare(
                "SELECT DISTINCT post_id FROM {$wpdb->postmeta} 
                 WHERE meta_value LIKE %s
                 LIMIT 100",
                $pattern
            ));

            if ( ! empty( $results ) ) {
                $used_by = array_merge( $used_by, $results );
            }
        }

        $used_by = array_unique( array_filter( $used_by ) );

        return [
            'used' => ! empty( $used_by ),
            'used_by' => $used_by,
            'source' => 'custom_field'
        ];
    }

    public function get_name() {
        return 'Custom Fields Detector';
    }

    public function is_available() {
        return true;
    }
}
