<?php
/**
 * Menu Detector
 * 
 * Detects media in navigation menus
 * Performance: Fast (term meta queries)
 */

class ORPHANIX_Menu_Detector implements ORPHANIX_Usage_Detector {
    
    public function detect( $attachment_id, $file_url ) {
        global $wpdb;

        if ( ! $attachment_id ) {
            return [
                'used' => false,
                'used_by' => [],
                'source' => 'menu'
            ];
        }

        // Check menu items
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
        $results = $wpdb->get_col( $wpdb->prepare(
            "SELECT term_id FROM {$wpdb->termmeta} 
             WHERE meta_key = 'menu-item-object-id' 
             AND meta_value = %d",
            $attachment_id
        ));

        return [
            'used' => ! empty( $results ),
            'used_by' => $results,
            'source' => 'menu'
        ];
    }

    public function get_name() {
        return 'Menu Detector';
    }

    public function is_available() {
        return true;
    }
}
