<?php
/**
 * Gutenberg Block Detector
 * 
 * Detects media in Gutenberg block comments
 * Performance: Fast (regex pattern matching)
 */

class ORPHANIX_Gutenberg_Detector implements ORPHANIX_Usage_Detector {
    
    public function detect( $attachment_id, $file_url ) {
        global $wpdb;

        if ( ! $attachment_id ) {
            return [
                'used' => false,
                'used_by' => [],
                'source' => 'gutenberg'
            ];
        }

        // Search for block comments with attachment ID
        $pattern = '%<!-- wp:%"id":' . intval( $attachment_id ) . '%';
        
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
        $results = $wpdb->get_col( $wpdb->prepare(
            "SELECT ID FROM {$wpdb->posts} 
             WHERE post_content LIKE %s 
             AND post_status = 'publish'",
            $pattern
        ));

        // Also check for gallery IDs array
        $gallery_pattern = '%"ids":%[%' . intval( $attachment_id ) . '%]%';
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
        $gallery_results = $wpdb->get_col( $wpdb->prepare(
            "SELECT ID FROM {$wpdb->posts} 
             WHERE post_content LIKE %s 
             AND post_status = 'publish'",
            $gallery_pattern
        ));

        $used_by = array_unique( array_merge( $results, $gallery_results ) );

        return [
            'used' => ! empty( $used_by ),
            'used_by' => $used_by,
            'source' => 'gutenberg'
        ];
    }

    public function get_name() {
        return 'Gutenberg Blocks Detector';
    }

    public function is_available() {
        return function_exists( 'register_block_type' ); // Gutenberg available
    }
}
