<?php
/**
 * Featured Image Detector
 * 
 * Detects media used as featured images (_thumbnail_id)
 * Performance: Fast (indexed query)
 */

class ORPHANIX_Featured_Image_Detector implements ORPHANIX_Usage_Detector {
    
    public function detect( $attachment_id, $file_url ) {
        global $wpdb;

        if ( ! $attachment_id ) {
            return [
                'used' => false,
                'used_by' => [],
                'source' => 'featured_image'
            ];
        }

        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
        $results = $wpdb->get_col( $wpdb->prepare(
            "SELECT post_id FROM {$wpdb->postmeta} 
             WHERE meta_key = '_thumbnail_id' 
             AND meta_value = %d",
            $attachment_id
        ));

        return [
            'used' => ! empty( $results ),
            'used_by' => $results,
            'source' => 'featured_image'
        ];
    }

    public function get_name() {
        return 'Featured Image Detector';
    }

    public function is_available() {
        return true; // Always available
    }
}
