<?php
/**
 * Post Content Detector
 * 
 * Detects media referenced in post_content
 * Performance: Medium (LIKE query)
 */

class ORPHANIX_Content_Detector implements ORPHANIX_Usage_Detector {
    
    public function detect( $attachment_id, $file_url ) {
        global $wpdb;

        $used_by = [];
        
        // Extract filename from URL
        $filename = basename( $file_url );
        
        // Search patterns
        $patterns = [
            '%' . $wpdb->esc_like( $file_url ) . '%',          // Full URL
            '%' . $wpdb->esc_like( $filename ) . '%',          // Filename only
        ];

        // Add wp-image-ID pattern if attachment ID exists
        if ( $attachment_id ) {
            $patterns[] = '%wp-image-' . intval( $attachment_id ) . '%';
        }

        foreach ( $patterns as $pattern ) {
            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
            $results = $wpdb->get_col( $wpdb->prepare(
                "SELECT ID FROM {$wpdb->posts} 
                 WHERE post_content LIKE %s 
                 AND post_status = 'publish'
                 LIMIT 100",
                $pattern
            ));

            if ( ! empty( $results ) ) {
                $used_by = array_merge( $used_by, $results );
            }
        }

        $used_by = array_unique( $used_by );

        return [
            'used' => ! empty( $used_by ),
            'used_by' => $used_by,
            'source' => 'post_content'
        ];
    }

    public function get_name() {
        return 'Post Content Detector';
    }

    public function is_available() {
        return true;
    }
}
