<?php
/**
 * Advanced Custom Fields Detector
 * 
 * Detects media in ACF fields
 * Performance: Medium (field-specific queries)
 */

class ORPHANIX_ACF_Detector implements ORPHANIX_Usage_Detector {
    
    public function detect( $attachment_id, $file_url ) {
        global $wpdb;

        if ( ! $this->is_available() || ! $attachment_id ) {
            return [
                'used' => false,
                'used_by' => [],
                'source' => 'acf'
            ];
        }

        // Search ACF fields (meta_key pattern: field_*)
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
        $results = $wpdb->get_col( $wpdb->prepare(
            "SELECT post_id FROM {$wpdb->postmeta} 
             WHERE meta_key LIKE %s 
             AND meta_value = %d",
            'field_%',
            $attachment_id
        ) );

        return [
            'used' => ! empty( $results ),
            'used_by' => $results,
            'source' => 'acf'
        ];
    }

    public function get_name() {
        return 'ACF Detector';
    }

    public function is_available() {
        return function_exists( 'acf' ) || class_exists( 'ACF' );
    }
}
