<?php
class ORPHANIX_Scan_Repository extends ORPHANIX_DB {
    public function all_scans() {
        $table = $this->validated_scans_table();
        if ( '' === $table ) {
            return array();
        }
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.InterpolatedNotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
        return $this->wpdb->get_results( "SELECT * FROM {$table} ORDER BY started_at DESC", ARRAY_A );
    }

    public function find($id) {
        $table = $this->validated_scans_table();
        if ( '' === $table ) {
            return null;
        }
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.PreparedSQL.InterpolatedNotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
        return $this->wpdb->get_row( $this->wpdb->prepare( "SELECT * FROM {$table} WHERE id = %d", $id ), ARRAY_A );
    }

    public function update_status($id, $status) {
        $table = $this->validated_scans_table();
        if ( '' === $table ) {
            return false;
        }
        return $this->wpdb->update($table, ['status' => $status], ['id' => $id]);
    }

    public function delete($id) {
        $table = $this->validated_scans_table();
        if ( '' === $table ) {
            return false;
        }
        return $this->wpdb->delete($table, ['id' => $id]);
    }

    private function validated_scans_table() {
        $table = $this->table('scans');
        $allowed_tables = array(
            $this->wpdb->prefix . 'orphanix_scans',
        );

        if ( ! is_string( $table ) || '' === $table ) {
            return '';
        }
        if ( ! preg_match( '/^[A-Za-z0-9_]+$/', $table ) ) {
            return '';
        }
        if ( 0 !== strpos( $table, $this->wpdb->prefix ) ) {
            return '';
        }
        if ( ! in_array( $table, $allowed_tables, true ) ) {
            return '';
        }

        return $table;
    }
}
