<?php
class ORPHANIX_Loader {
	public function __construct() {
		// Shared paths helper.
		require_once ORPHANIX_PATH . 'includes/utils/class-orphanix-paths.php';

		// Core
		require_once ORPHANIX_PATH . 'includes/core/class-orphanix-activator.php';
		require_once ORPHANIX_PATH . 'includes/core/class-orphanix-deactivator.php';
		require_once ORPHANIX_PATH . 'includes/core/class-orphanix-i18n.php';
		require_once ORPHANIX_PATH . 'includes/core/class-orphanix-audit-logger.php';

		// Database
		require_once ORPHANIX_PATH . 'includes/database/class-orphanix-db.php';
		require_once ORPHANIX_PATH . 'includes/database/class-orphanix-scan-repository.php';
		require_once ORPHANIX_PATH . 'includes/database/class-orphanix-scan-items-repository.php';
		require_once ORPHANIX_PATH . 'includes/database/class-orphanix-trash-repository.php';

		// Utils
		require_once ORPHANIX_PATH . 'includes/utils/class-orphanix-logger.php';

		// Scan
		require_once ORPHANIX_PATH . 'includes/scan/class-orphanix-scan-manager.php';
		require_once ORPHANIX_PATH . 'includes/scan/class-orphanix-regular-scan.php';
		require_once ORPHANIX_PATH . 'includes/scan/class-orphanix-deep-scan.php';
		require_once ORPHANIX_PATH . 'includes/scan/class-orphanix-batch-processor.php';
		require_once ORPHANIX_PATH . 'includes/scan/class-orphanix-detector-registry.php';
		require_once ORPHANIX_PATH . 'includes/scan/class-orphanix-result-resolver.php';

		// Detector Interface
		require_once ORPHANIX_PATH . 'includes/detectors/interface-usage-detector.php';

		// Core Detectors
		require_once ORPHANIX_PATH . 'includes/detectors/class-orphanix-featured-image-detector.php';
		require_once ORPHANIX_PATH . 'includes/detectors/class-orphanix-content-detector.php';
		require_once ORPHANIX_PATH . 'includes/detectors/class-orphanix-meta-detector.php';

		// Page Builder Detectors
		require_once ORPHANIX_PATH . 'includes/detectors/class-orphanix-gutenberg-detector.php';
		require_once ORPHANIX_PATH . 'includes/detectors/class-orphanix-elementor-detector.php';

		// Custom Field Plugin Detectors
		require_once ORPHANIX_PATH . 'includes/detectors/class-orphanix-acf-detector.php';

		// Other Detectors
		require_once ORPHANIX_PATH . 'includes/detectors/class-orphanix-woocommerce-detector.php';
		require_once ORPHANIX_PATH . 'includes/detectors/class-orphanix-widget-detector.php';
		require_once ORPHANIX_PATH . 'includes/detectors/class-orphanix-menu-detector.php';
		require_once ORPHANIX_PATH . 'includes/detectors/class-orphanix-theme-file-detector.php';
		require_once ORPHANIX_PATH . 'includes/detectors/class-orphanix-deep-db-detector.php';

		// Live Scan
		require_once ORPHANIX_PATH . 'includes/pro/class-orphanix-live-scan.php';

		// AJAX
		require_once ORPHANIX_PATH . 'includes/ajax/class-orphanix-scan-ajax.php';
		require_once ORPHANIX_PATH . 'includes/ajax/class-orphanix-delete-ajax.php';
		require_once ORPHANIX_PATH . 'includes/ajax/class-orphanix-restore-ajax.php';
		require_once ORPHANIX_PATH . 'includes/ajax/class-orphanix-wizard-ajax.php';
		require_once ORPHANIX_PATH . 'includes/ajax/class-orphanix-live-scan-ajax.php';

		// Admin
		require_once ORPHANIX_PATH . 'includes/admin/class-orphanix-admin-menu.php';
		require_once ORPHANIX_PATH . 'includes/admin/class-orphanix-dashboard.php';
		require_once ORPHANIX_PATH . 'includes/admin/class-orphanix-media-scan.php';
		require_once ORPHANIX_PATH . 'includes/admin/class-orphanix-broken-scan.php';
		require_once ORPHANIX_PATH . 'includes/admin/class-orphanix-analytics.php';
		require_once ORPHANIX_PATH . 'includes/admin/class-orphanix-settings.php';
		require_once ORPHANIX_PATH . 'includes/admin/class-orphanix-live-scan-page.php';

		// Security
		require_once ORPHANIX_PATH . 'includes/security/class-orphanix-capabilities.php';
		require_once ORPHANIX_PATH . 'includes/security/class-orphanix-nonce.php';
		require_once ORPHANIX_PATH . 'includes/security/class-orphanix-path-validator.php';
	}

	public function run() {
		new ORPHANIX_Admin_Menu();
		new ORPHANIX_Settings();
		new ORPHANIX_Scan_Ajax();
		new ORPHANIX_Delete_Ajax();
		new ORPHANIX_Restore_Ajax();
		new ORPHANIX_Wizard_Ajax();
		new ORPHANIX_Live_Scan_Ajax();
	}
}
