<?php
class ORPHANIX_Activator {
	public static function activate() {
		global $wpdb;

		require_once ABSPATH . 'wp-admin/includes/upgrade.php';

		$charset_collate = $wpdb->get_charset_collate();
		$scans_table     = $wpdb->prefix . 'orphanix_scans';
		$items_table     = $wpdb->prefix . 'orphanix_scan_items';
		$live_table      = $wpdb->prefix . 'orphanix_live_scan_details';

		$sql1 = "CREATE TABLE {$scans_table} (
			id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
			scan_type VARCHAR(20) NOT NULL,
			scan_mode VARCHAR(20) NOT NULL,
			status VARCHAR(20) NOT NULL,
			total_files INT DEFAULT 0,
			processed_files INT DEFAULT 0,
			used_files INT DEFAULT 0,
			orphan_files INT DEFAULT 0,
			settings LONGTEXT NULL,
			started_at DATETIME NOT NULL,
			completed_at DATETIME NULL,
			created_by BIGINT UNSIGNED NOT NULL,
			PRIMARY KEY (id),
			KEY scan_type (scan_type),
			KEY status (status)
		) $charset_collate;";

		$sql2 = "CREATE TABLE {$items_table} (
			id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
			scan_id BIGINT UNSIGNED NOT NULL,
			attachment_id BIGINT UNSIGNED NULL,
			file_path TEXT NOT NULL,
			file_url TEXT NULL,
			file_size BIGINT DEFAULT 0,
			alt_text TEXT NULL,
			directory_type VARCHAR(30) NOT NULL,
			usage_context TEXT NULL,
			status VARCHAR(20) NOT NULL,
			live_used TINYINT DEFAULT 0,
			live_url_count INT DEFAULT 0,
			created_at DATETIME NOT NULL,
			PRIMARY KEY (id),
			KEY scan_id (scan_id),
			KEY status (status)
		) $charset_collate;";

		$sql3 = "CREATE TABLE {$live_table} (
			id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
			scan_item_id BIGINT UNSIGNED NOT NULL,
			page_url TEXT NOT NULL,
			page_title VARCHAR(255) NULL,
			created_at DATETIME NOT NULL,
			PRIMARY KEY (id),
			KEY scan_item_id (scan_item_id)
		) $charset_collate;";

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.SchemaChange
		dbDelta( $sql1 );
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.SchemaChange
		dbDelta( $sql2 );
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.SchemaChange
		dbDelta( $sql3 );

		self::ensure_scan_item_columns( $items_table );

		update_option( 'orphanix_db_version', 1 );
		update_option( 'orphanix_db_migrated', 1 );
	}

	private static function ensure_scan_item_columns( string $items_table ) {
		global $wpdb;
		$validated_items_table = self::validate_prefixed_table_name( $items_table, $wpdb->prefix );
		if ( '' === $validated_items_table ) {
			return;
		}

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
		if ( null === $wpdb->get_var( $wpdb->prepare( 'SHOW COLUMNS FROM `' . $validated_items_table . '` LIKE %s', 'live_used' ) ) ) {
			// phpcs:ignore WordPress.DB.DirectDatabaseQuery.SchemaChange, WordPress.DB.PreparedSQL.InterpolatedNotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
			$wpdb->query( "ALTER TABLE {$validated_items_table} ADD live_used TINYINT DEFAULT 0" );
		}

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
		if ( null === $wpdb->get_var( $wpdb->prepare( 'SHOW COLUMNS FROM `' . $validated_items_table . '` LIKE %s', 'live_url_count' ) ) ) {
			// phpcs:ignore WordPress.DB.DirectDatabaseQuery.SchemaChange, WordPress.DB.PreparedSQL.InterpolatedNotPrepared, PluginCheck.Security.DirectDB.UnescapedDBParameter
			$wpdb->query( "ALTER TABLE {$validated_items_table} ADD live_url_count INT DEFAULT 0" );
		}
	}

	private static function validate_prefixed_table_name( string $table_name, string $prefix ): string {
		if ( '' === $table_name || '' === $prefix ) {
			return '';
		}
		if ( ! preg_match( '/^[A-Za-z0-9_]+$/', $table_name ) ) {
			return '';
		}
		if ( 0 !== strpos( $table_name, $prefix ) ) {
			return '';
		}
		return $table_name;
	}
}

