<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class ORPHANIX_Scan_Ajax {
    public function __construct() {
        add_action('wp_ajax_orphanix_start_scan', [$this,'start_scan']);
    }

    public function start_scan() {
        check_ajax_referer('orphanix_start_scan','nonce');
        if ( ! current_user_can('manage_options') ) {
            wp_send_json_error(__('Unauthorized','orphanix-media-cleanup'));
        }

        $type = isset( $_POST['scan_type'] ) ? sanitize_text_field( wp_unslash( $_POST['scan_type'] ) ) : 'regular';
        // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
        $raw_settings = isset( $_POST['settings'] ) ? wp_unslash( $_POST['settings'] ) : [];
        $settings = is_array( $raw_settings ) ? $raw_settings : [];
        
        // Sanitize settings array
        $settings = array_map(function($value) {
            if (is_array($value)) {
                return array_map('sanitize_text_field', $value);
            }
            return sanitize_text_field($value);
        }, $settings);
        
        // Validate scan type
        if (!in_array($type, ['regular', 'deep'])) {
            $type = 'regular';
        }

        if ($type === 'regular') {
            $scan = new ORPHANIX_Regular_Scan();
        } else {
            $scan = new ORPHANIX_Deep_Scan();
        }

        $scan_id = $scan->run($settings);
        wp_send_json_success(['scan_id'=>$scan_id]);
    }
}
