<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class ORPHANIX_Restore_Ajax {
    public function __construct() {
        add_action('wp_ajax_orphanix_restore_item', [$this,'restore_item']);
    }

    public function restore_item() {
        check_ajax_referer('orphanix_restore_file','nonce');
        if ( ! current_user_can('manage_options') ) {
            wp_send_json_error(__('Unauthorized','orphanix-media-cleanup'));
        }

        $id = isset( $_POST['id'] ) ? absint( wp_unslash( $_POST['id'] ) ) : 0;
        if ( ! $id ) {
            wp_send_json_error(__('Invalid restore ID','orphanix-media-cleanup'));
        }
        $repo = new ORPHANIX_Trash_Repository();
        $success = $repo->restore($id);

        if ($success) {
            wp_send_json_success(['restored'=>$id]);
        } else {
            wp_send_json_error(__('Restore failed','orphanix-media-cleanup'));
        }
    }
}
