<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class ORPHANIX_Live_Scan_Ajax {
    public function __construct() {
        add_action('wp_ajax_orphanix_start_live_scan', [$this, 'start_live_scan']);
        add_action('wp_ajax_orphanix_get_live_scan_progress', [$this, 'get_live_scan_progress']);
    }

    public function start_live_scan() {
        $nonce = isset( $_POST['nonce'] ) ? sanitize_text_field( wp_unslash( $_POST['nonce'] ) ) : '';
        if ( ! wp_verify_nonce( $nonce, 'orphanix_scan_nonce' ) ) {
            wp_send_json_error(__('Nonce verification failed', 'orphanix-media-cleanup'), 403);
        }
        
        if (!current_user_can('manage_options')) {
            wp_send_json_error(__('Unauthorized', 'orphanix-media-cleanup'), 403);
        }

        $media_scan_id = isset( $_POST['scan_id'] ) ? absint( wp_unslash( $_POST['scan_id'] ) ) : 0;
        if (!$media_scan_id) {
            wp_send_json_error(__('Invalid scan ID', 'orphanix-media-cleanup'));
        }

        try {
            $live_scan = new ORPHANIX_Live_Scan();
            $live_scan->init_live_scan($media_scan_id);

            wp_send_json_success([
                'scan_id' => $media_scan_id,
                'message' => 'initialized'
            ]);
        } catch (Throwable $e) {
            if ( class_exists( 'ORPHANIX_Logger' ) ) {
                ORPHANIX_Logger::log( 'Live Scan AJAX Error', [ 'message' => $e->getMessage() ] );
            }
            wp_send_json_error( __( 'Live scan failed.', 'orphanix-media-cleanup' ) );
        }
    }

    public function get_live_scan_progress() {
        $nonce = isset( $_POST['nonce'] ) ? sanitize_text_field( wp_unslash( $_POST['nonce'] ) ) : '';
        if ( ! wp_verify_nonce( $nonce, 'orphanix_scan_nonce' ) ) {
            wp_send_json_error(__('Nonce verification failed', 'orphanix-media-cleanup'), 403);
        }
        
        if (!current_user_can('manage_options')) {
            wp_send_json_error(__('Unauthorized', 'orphanix-media-cleanup'), 403);
        }

        $media_scan_id = isset( $_POST['scan_id'] ) ? absint( wp_unslash( $_POST['scan_id'] ) ) : 0;
        if (!$media_scan_id) {
            wp_send_json_error(__('Invalid scan ID', 'orphanix-media-cleanup'));
        }

        $live_scan = new ORPHANIX_Live_Scan();
        $progress = $live_scan->process_live_scan_batch($media_scan_id, 5);

        if (!$progress) {
            $progress = [
                'status' => 'not_started',
                'processed' => 0,
                'total' => 0,
                'percentage' => 0,
                'current_url' => ''
            ];
        }

        wp_send_json_success($progress);
    }
}
